package com.weface.common.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


/**
 * 短信发送操作类
 */
@Slf4j
public class ShortMsgSend {
    /**
     * 看看社保
     */
    //static String url = "http://114.55.5.4/hy/";
    //static String uid = "90062";
    //static String auth = "ec7fa119ecc34b385549e8e154e5bdd5";

    /**
     * 看看生活
     */
//    private static final String url = "http://submit.10690221.com:9012/hy/";
//    private static final String uid = "90063";
//    private static final String auth = "c4daa5fe21eabe16a765eefe0573dbdf";
    public static boolean sendMobileByRegister(String paramContent, String telPhone, Integer messageTemplate) throws IOException {
        String url = null;
        String uid = null;
        String auth = null;
        switch (messageTemplate) {
            //看看生活
            case 1:
                url = "http://submit.10690221.com:9012/hy/";
                uid = "90063";
                auth = "c4daa5fe21eabe16a765eefe0573dbdf";
                break;
            //看看社保
            case 2:
                url = "http://114.55.5.4/hy/";
                uid = "90062";
                auth = "ec7fa119ecc34b385549e8e154e5bdd5";
                break;
            default:
                break;
        }
        if (url == null) {
            log.error("短信模板参数错误:{}", messageTemplate);
            return false;
        }
        return sendMobileByRegister(paramContent, telPhone, url, uid, auth);
    }

    private static boolean sendMobileByRegister(String paramContent, String telPhone, String url, String uid, String auth) throws IOException {
        String content = java.net.URLEncoder.encode(paramContent, "gbk");
        Map<String, Object> map = new HashMap<>();
        map.put("uid", uid);
        map.put("auth", auth);
        map.put("mobile", telPhone);
        map.put("expid", "0");
        map.put("msg", content);
        HttpRequest post = HttpUtil.createPost(url);
        HttpResponse execute = post.form(map).execute();
        int status = execute.getStatus();
        if (status == 200) {
            String postResult = execute.body();
            log.error("{}的短信发生结果:{}", telPhone, postResult);
            System.out.println(postResult);
            try {
                return postResult.split(",")[0].equals("0");
            } catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
    }


    /*
     * 功能描述:
     * @auther: 信息
     * @date: 2018/12/24 17:30
     */
    public static String Mesresult = "请您于6月10日之前，通过“看看卫健”软件，完成高龄补贴资格认证，每年3月、6月、9月、12月的1-10日为认证时间，不认证将停发或终止补贴";

    public static void main(String[] args) {
        String telphone = "15538250098";

        String msg = "尊敬的用户，请尽快完成社保认证，领取养老金。认证下载链接http://dwz.date/eHEH";
        System.out.println(msg.length());
        try {
            boolean sabeResult = sendMobileByRegister(msg, telphone, 1);
            if (sabeResult) {
                System.out.println("短信发送成功");
            } else {
                System.out.println("短信发送失败");
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}
