package com.weface.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 用户ID标签关联表
 *
 * @author chenshun
 * @date 2021-11-30 18:57:06
 */
@ExcelTarget("tUserTagEntity")
@Data
@TableName("t_user_tag")
public class UserTagEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @Excel(name = "id", width = 10)
    @TableId
    private Long id;
    /**
     * 用户ID
     */
    private String uid;
    /**
     * 用户手机号
     */
    private String tel;
    /**
     * 标签id
     */
	@Excel(name = "用户Gid", width = 40)
    private String gid;
    /**
     * 更新时间
     */
    private Date saveDate;
    /**
     * 标签数据
     */
    @ExcelEntity(name = "标签列表",id = "id")
    @TableField(exist = false)
    private List<MenuTagsEntity> list;

}
