package com.weface.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.weface.entity.UserTagEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 用户ID标签关联表
 *
 * @author chenshun
 * @date 2021-11-30 18:57:06
 */
@Mapper
public interface UserTagDao extends BaseMapper<UserTagEntity> {

    /**
     * 查询用户标签导出
     *
     * @param list 用户uid
     * @return 标签信息
     */
    List<UserTagEntity> findUserTags(List<String> list);

    /**
     * 查询今天用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByTodayAndIdBefore(Integer id);

    /**
     * 根据时间查询用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit);

    /**
     * 查询库中无标签用户
     *
     * @return 用户信息
     */
    List<UserTagEntity> findNoTagUser(@Param("star") Integer star, @Param("end") Integer end);

    /**
     * 查询用户和标签信息
     *
     * @param star 起始页
     * @param end  每页条数
     * @return 用户标签数据
     */
    List<UserTagEntity> getUserList(@Param("star") Integer star, @Param("end") Integer end, @Param("param") Map<String, Object> param);

}
