package com.weface.controller;

import com.weface.code.CommonResult;
import com.weface.common.validator.ValidatorUtils;
import com.weface.dto.UserMenuFrom;
import com.weface.service.UserMenusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : Administrator
 * @date : 2022/2/10 11:08
 */
@RestController
@RequestMapping("/sys/tags")
public class UserMenuController {
    @Autowired
    private UserMenusService userMenusService;

    /**
     * 添加用户标签
     */
    @PostMapping("/save_user_tag")
    public CommonResult saveUserTag(@RequestBody UserMenuFrom userMenuFrom) {
        ValidatorUtils.validateEntity(userMenuFrom, UserMenuFrom.UserMenus.class);
        return userMenusService.saveUserTag(userMenuFrom);
    }

    /**
     * 删除用户标签
     */
    @PostMapping("/del_user_tag")
    public CommonResult delUserTag(@RequestBody UserMenuFrom userMenuFrom){
        ValidatorUtils.validateEntity(userMenuFrom, UserMenuFrom.UserMenus.class);
        return userMenusService.delUserTag(userMenuFrom);
    }
}
