package com.weface.serviceimpl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.code.CommonResult;
import com.weface.common.utils.BeanUtils;
import com.weface.common.utils.SnowIdUtil;
import com.weface.dao.MenuTagsDao;
import com.weface.dto.MenuTagsForm;
import com.weface.entity.MenuTagsEntity;
import com.weface.service.MenuTagsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;


/**
 * @author Administrator
 */
@Slf4j
@Transactional(rollbackFor = {Exception.class})
@Service("menuTagsService")
public class MenuTagsServiceImpl extends ServiceImpl<MenuTagsDao, MenuTagsEntity> implements MenuTagsService {

    private static final String CODE = "kk";

    @Override
    public List<Object> getTagsList() {
        List<MenuTagsEntity> list = this.baseMapper.getTagsList();
        List<Object> firstChild = new ArrayList<>();
        Set<String> level_first = list.stream().map(MenuTagsEntity::getLevelFirst).collect(Collectors.toSet());
        for (String first : level_first) {
            List<Object> secondChild = new ArrayList<>();
            Set<String> level_second = list.stream().filter(x -> first.equals(x.getLevelFirst())).map(MenuTagsEntity::getLevelSecond).collect(Collectors.toSet());
            for (String second : level_second) {
                Map<String, Object> second_map = new HashMap<>();
                List<Map<String, Object>> level_third = list.stream()
                        .filter(x -> second.equals(x.getLevelSecond()) && first.equals(x.getLevelFirst()))
                        .sorted(Comparator.comparing(MenuTagsEntity::getCreateTime).reversed())
                        .map(x -> {
                            Map<String, Object> hashMap = new HashMap<>();
                            hashMap.put("level", "3");
                            hashMap.put("menu_id", String.valueOf(x.getId()));
                            hashMap.put("label", x.getLevelThird() + "," + x.getCode());
                            return hashMap;
                        }).collect(Collectors.toList());
                second_map.put("level", "2");
                second_map.put("label", second);
                second_map.put("children", level_third);
                secondChild.add(second_map);
            }
            Map<String, Object> first_map = new HashMap<>(level_first.size());
            first_map.put("level", "1");
            first_map.put("label", first);
            first_map.put("children", secondChild);
            firstChild.add(first_map);
        }
        return firstChild;
    }

    @Override
    public CommonResult saveTag(MenuTagsForm menuTagsForm) {
        try {
            MenuTagsEntity menuTagsEntity = new MenuTagsEntity();
            BeanUtil.copyProperties(menuTagsForm, menuTagsEntity, BeanUtils.getNullPropertyNames(menuTagsForm));

            menuTagsEntity.setId(SnowIdUtil.nextId());
            String tagCode = "";
            boolean flag = false;
            while (!flag) {
                tagCode = CODE + RandomUtil.randomString(6);
                int count = this.count(new QueryWrapper<MenuTagsEntity>().lambda().eq(MenuTagsEntity::getCode, tagCode));
                if (count == 0) {
                    flag = true;
                }
            }
            menuTagsEntity.setCode(tagCode);
            menuTagsEntity.setUpdateTime(new Date());
            this.save(menuTagsEntity);
            return CommonResult.success(tagCode);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行新增标签错误{}", e.getMessage());
        }
        return CommonResult.failed();
    }

    @Override
    public CommonResult updateTag(MenuTagsForm menuTagsForm) {
        try {
            Long id = menuTagsForm.getId();
            MenuTagsEntity byId = this.getById(id);
            if (byId == null) {
                return CommonResult.failed();
            }
            BeanUtil.copyProperties(menuTagsForm, byId, BeanUtils.getNullPropertyNames(menuTagsForm));
            byId.setUpdateTime(new Date());
            this.updateById(byId);
            return CommonResult.success();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行更新标签错误{}", e.getMessage());
        }
        return CommonResult.failed();
    }
}