package com.weface.serviceimpl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.common.utils.Constant;
import com.weface.common.utils.PageUtils;
import com.weface.common.utils.RedisUtil;
import com.weface.dao.UserTagDao;
import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserTagEntity;
import com.weface.service.UserTagService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


/**
 * @author Administrator
 */
@Service("tUserTagService")
public class UserTagServiceImpl extends ServiceImpl<UserTagDao, UserTagEntity> implements UserTagService {

    @Override
    public List<UserTagEntity> findUserTags(List<String> list) {
        return this.baseMapper.findUserTags(list);
    }

    @Override
    public List<UserTagEntity> findUserByTodayAndIdBefore(Integer id) {
        return this.baseMapper.findUserByTodayAndIdBefore(id);
    }

    @Override
    public List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit) {
        return this.baseMapper.findUserByIdAfter(id, limit);
    }

    @Override
    public List<UserTagEntity> findNoTagUser(Integer star, Integer end) {
        return this.baseMapper.findNoTagUser(star, end);
    }

    @Override
    public PageUtils getUserList(Map<String, Object> params) {
        //分页参数
        int page = 1;
        int limit = 10;
        if (params.get(Constant.PAGE) != null) {
            page = Convert.toInt(params.get(Constant.PAGE));
        }
        if (params.get(Constant.LIMIT) != null) {
            limit = Convert.toInt(params.get(Constant.LIMIT));
        }
        int star = (page - 1) * limit;
        List<UserTagEntity> list = this.baseMapper.getUserList(star, limit, params);
        String count = RedisUtil.StringOps.get("tags:user:count");
        if (StringUtils.isBlank(count)) {
            count = String.valueOf(this.count());
            RedisUtil.StringOps.setEx("tags:user:count", count, 60, TimeUnit.MINUTES);
        }
        List<Object> maps = new ArrayList<>();
        list.forEach(x -> {
            Map<String, Object> map = BeanUtil.beanToMap(x, true, true);
            List<MenuTagsEntity> tag = x.getList();
            if (CollUtil.isNotEmpty(tag)) {
                map.put("list", tag.stream().map(y ->
                {
                    Map<String, Object> map1 = BeanUtil.beanToMap(y, true, true);
                    map1.put("id", String.valueOf(map1.get("id")));
                    return map1;
                }).collect(Collectors.toList()));
            }
            maps.add(map);
        });
        return new PageUtils(maps, Integer.parseInt(count), limit, page);
    }
}