package com.weface.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@Data
@TableName("tb_menu_tags")
public class MenuTagsEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;
    /**
     * 一级标签名称
     */
    private String levelFirst;
    /**
     * 二级标签名称
     */
    private String levelSecond;
    /**
     * 三级标签名称
     */
    private String levelThird;
    /**
     * 编码
     */
    private String code;
    /**
     * 套餐等级
     */
    private Integer menuGrade;
    /**
     * 是否有权重
     */
    private String weight;
    /**
     * 是否有效 1:有效 0 无效
     */
    @TableLogic(value = "1", delval = "0")
    @TableField(fill = FieldFill.INSERT)
    private Integer isValid;
    /**
     *
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;
    /**
     *
     */
    private Date updateTime;

}
