package com.weface.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @CreateTime: 2021/11/3
 */
@Data
public class MenuTagsForm implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * ID
     */
    @NotNull(message = "id不能为空", groups = {UpdateTag.class})
    private Long id;
    /**
     * 一级标签名称
     */
    @NotBlank(message = "一级标签不能为空", groups = {SaveTag.class})
    private String levelFirst;
    /**
     * 二级标签名称
     */
    @NotBlank(message = "二级标签不能为空", groups = {SaveTag.class})
    private String levelSecond;
    /**
     * 三级标签名称
     */
    @NotBlank(message = "三级标签不能为空", groups = {SaveTag.class})
    private String levelThird;
    /**
     * 套餐等级
     */
    private Integer menuGrade;
    /**
     * 是否有权重
     */
    private String weight;

    public interface SaveTag {

    }

    public interface UpdateTag {

    }
}
