package com.weface.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author : Administrator
 */
@Data
public class InformForm {
    //标题
    @NotBlank(message = "标题不能为空",groups = {PushValid.class})
    private String title;
    //内容
    @NotBlank(message = "内容不能为空",groups = {PushValid.class})
    private String body;
    //跳转url
    @NotBlank(message = "url不能为空",groups = {PushValid.class})
    private String url;
    //推送类型 0:h5 1:原生
    private Integer pushType;
    //跳转功能名称
    private String className;
    //功能标题
    private String classTitle;
    //是否需要登录
    private String needLogin;
    //请求应用名称首字母小写 例:看看生活->kksh
    @NotBlank(message = "应用名称不能为空",groups = {PushValid.class})
    private String equipmentType;
    //推送设备 4 android 1: ios
    private Integer device;
    //定速推送，例如100，个推控制下发速度在100条/秒左右，0表示不限速
    private Integer speed;
    //推送目标
    private String cid;
    //推送手机号
    private String phone;
    //推送模板
    private Integer messageTemplate;


    public interface PushValid{

    }
}
