package com.weface.controller;

import com.weface.code.CommonResult;
import com.weface.common.utils.Constant;
import com.weface.common.validator.ValidatorParam;
import com.weface.common.validator.ValidatorUtils;
import com.weface.component.GeTuiService;
import com.weface.component.MobPushService;
import com.weface.dto.InformForm;
import com.weface.dto.MsgDTO;
import com.weface.dto.PushDTO;
import com.weface.service.PushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("push")
public class PushController {

    @Autowired
    private PushService pushService;
    @Autowired
    private GeTuiService geTuiService;
    @Autowired
    private MobPushService mobPushService;

    @PostMapping("list")
    public CommonResult pushList(@RequestBody PushDTO param) throws Exception {
        return pushService.pushList(param);
    }

    @PostMapping("single")
    public CommonResult pushSingle(@RequestBody MsgDTO param) {
        return pushService.pushSingle(param);
    }

    @PostMapping("/all")
    public CommonResult pushAll(InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        if(informForm.getEquipmentType().equals("kksh"))
        {
            mobPushService.mobPush(informForm, Constant.PushTarget.RADIO);
        }
        return geTuiService.listPush(informForm);
    }

    @PostMapping("/single/alias")
    public CommonResult pushSingleAlias(@RequestBody InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult commonResult = ValidatorParam.validPushSingleAlias(informForm);
        if (commonResult != null) {
            return commonResult;
        }
        CommonResult result = mobPushService.mobPush(informForm, Constant.PushTarget.ALIAS);
        if (result != null) {
            return CommonResult.success();
        }
        return geTuiService.pushSingleAlias(informForm);
    }

    @PostMapping("/single/cid")
    public CommonResult pushSingleCid(@RequestBody InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult commonResult = ValidatorParam.validPushSingleAlias(informForm);
        if (commonResult != null) {
            return commonResult;
        }
        CommonResult result = mobPushService.mobPush(informForm, Constant.PushTarget.RIDS);
        if (result != null) {
            return CommonResult.success();
        }
        return geTuiService.pushSingleCid(informForm);
    }
}
