package com.weface.controller;

import com.weface.code.CommonResult;
import com.weface.common.utils.PageUtils;
import com.weface.service.UserTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;


/**
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@RestController
@RequestMapping("/sys/user")
public class UserTagsController {
    @Autowired
    private UserTagService userTagService;

    /**
     * 查询所有用户对应标签信息
     */
    @PostMapping("/list_user")
    public CommonResult list(@RequestBody Map<String, Object> params) {
        PageUtils page = userTagService.getUserList(params);
        return CommonResult.success(page);
    }


}
