package com.weface.component;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserTagEntity;
import com.weface.entity.UserMenusEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author Administrator
 * @CreateTime: 2021/11/2
 */
@Slf4j
@Component
public class MenuService {


    /**
     * 从map中解析标签并收集关系表数据
     *
     * @param map 个推返回数据
     * @return 标签数据
     */
    public List<UserMenusEntity> getTagUser(Map<String, Object> map, List<UserTagEntity> userInfo) {
        try {
            Snowflake snowflake = IdUtil.getSnowflake(1, 1);
            //获取所有用户标签
            List<Map<String, Object>> userTag = Convert.convert(new TypeReference<List<Map<String, Object>>>() {
            }, map.get("userTag"));
            //收集中间表数据
            List<UserMenusEntity> userMenusList = new ArrayList<>();
            //获取所有用户信息
            for (Map<String, Object> item : userTag) {
                //拿到当前用户giUid
                String userId = (String) item.get("userId");
                //拿到标签
                List<Long> list = Convert.convert(new TypeReference<List<Long>>() {
                }, item.get("tags"));
                //查找当前用户的id
                Optional<UserTagEntity> first = userInfo.stream().filter(x -> userId.equals(x.getGid())).findFirst();
                //如果对象不为空
                if (first.isPresent()) {
                    //拿到id
                    String uid = first.get().getUid();
                    //遍历标签id
                    Date date = new Date();
                    for (Long aLong : list) {
                        //填充数据
                        UserMenusEntity userMenusEntity = new UserMenusEntity();
                        userMenusEntity.setId(snowflake.nextId());
                        userMenusEntity.setUserId(uid);
                        userMenusEntity.setTagsId(aLong);
                        userMenusEntity.setIsValid(1);
                        userMenusEntity.setCreateTime(date);
                        //添加数据到集合内
                        userMenusList.add(userMenusEntity);
                    }
                }
            }
            return userMenusList;
        } catch (ConvertException e) {
            e.printStackTrace();
            log.error("转换用户标签失败{}", e.getMessage());
        }
        return null;
    }

    /**
     * 通过gid以及操作系统字段获取标签code并转为实际值，后存库并返回
     *
     * @param gidList 用户的giUid
     * @param tags    标签信息
     * @return 走個推查詢數據
     */
    public Map<String, Object> getUserTags(List<String> gidList, List<MenuTagsEntity> tags) {
        //获取token
        String kk_sh_token = "kk_sh_token";
        try {
            String authToken = GeTuiUtils.getAuthToken(kk_sh_token);
            //将token以及用户ID封装调用画像查询接口
            String result = GeTuiUtils.queryTagKKSH(gidList, authToken);
            JSONObject jsonObject = JSONObject.parseObject(result);
            //判断返回json内是否包含要解析的userTag
            if (jsonObject.containsKey("userTag")) {
                JSONArray userTag = jsonObject.getJSONArray("userTag");
                List<Map<String, Object>> userTags = getUserTagByTag(userTag, 1, tags);
                Map<String, Object> all = null;
                if (userTags != null && userTag.size() > 0) {
                    all = new HashMap<>(2);
                    //将数据封装并转为json格式返回
                    all.put("userTag", userTags);
                    all.put("error_code", 0);
                }
                return all;
            } else {
                log.error("看看生活:返回值内不包含需要解析的数据{}", jsonObject.toJSONString());
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行调用个推接口获取标签数据发生异常" + e.getMessage());
        }
        return null;
    }


    /**
     * 获取看看社保用户标签
     *
     * @param gidList 用户gid
     * @return 用户标签信息
     * @throws Exception 异常
     */
    private List<Map<String, Object>> getSBTags(List<String> gidList, List<MenuTagsEntity> tags) throws Exception {
        String kk_sb_token = "kk_sb_token";
        //获取token
        String authToken = GeTuiUtils.getAuthToken(kk_sb_token);
        //将token以及用户ID封装调用画像查询接口
        String result = GeTuiUtils.queryTagKKSB(gidList, authToken);
        JSONObject jsonObject = JSONObject.parseObject(result);
        //判断返回json内是否包含要解析的userTag
        if (jsonObject.containsKey("userTag")) {
            JSONArray userTag = jsonObject.getJSONArray("userTag");
            return getUserTagByTag(userTag, 2, tags);
        } else {
            log.error("看看社保:返回值内不包含需要解析的数据{}", jsonObject.toJSONString());
        }
        return null;
    }

    /**
     * 解析json拿到所有用户
     *
     * @param userTag 用户数据
     * @param type    解析类型 1 看看生活解析 2 看看社保解析
     * @return 標簽數據
     */
    private List<Map<String, Object>> getUserTagByTag(JSONArray userTag, int type, List<MenuTagsEntity> tags) throws Exception {
        //封装返回的数据userTags
        List<Map<String, Object>> userTags = null;
        //查询用户画像失败的gid用户
        List<String> gidList = new ArrayList<>();
        //解析用户标签
        if (userTag != null && userTag.size() > 0) {
            //初始化
            userTags = new ArrayList<>(userTag.size());
            for (Object o : userTag) {
                JSONObject jsonObject1 = JSONObject.parseObject(o.toString());
                String userId = "";
                if (jsonObject1.containsKey("userId")) {
                    userId = jsonObject1.getString("userId");
                }
                //如果从json中获取的当前giUid为空，则跳出本次循环
                if (StringUtils.isBlank(userId)) {
                    continue;
                }
                //判断返回json内是否包含要解析的error_code，并判断返回的json状态码是否正常
                Integer errorCode = jsonObject1.getInteger("error_code");
                if (errorCode == 0) {
                    //封装当前用户的所有tags信息
                    Map<String, Object> data = new HashMap<>(2);
                    //封装要返回的所有tags
                    List<Long> list = getMenuByTag(jsonObject1.getJSONArray("tags"), tags);
                    //根据giUid查询的标签如果为空则跳出本次循环
                    if (list != null && list.size() > 0) {
                        data.put("userId", userId);
                        data.put("tags", list);
                        userTags.add(data);
                    }
                } else if (errorCode == 109) {
                    if (type == 1) {
                        gidList.add(userId);
                    }
                }
            }

            //如果调用的是看看生活的用户标签失败时,尝试调取看看社保用户标签
            if (type == 1 && CollUtil.isNotEmpty(gidList)) {
                List<Map<String, Object>> sbTags = getSBTags(gidList, tags);
                if (sbTags != null && sbTags.size() > 0) {
                    userTags.addAll(sbTags);
                }
            }
        }
        return userTags;
    }

    /**
     * 解析json拿到当前用户对应的标签列表
     * 根据标签的code查询标签数据
     *
     * @param tags 标签
     * @return 標簽數據
     */
    private List<Long> getMenuByTag(JSONArray tags, List<MenuTagsEntity> menus) {
        List<Long> list = null;
        if (tags != null && tags.size() > 0) {
            list = new ArrayList<>(tags.size());
            for (Object tag : tags) {
                JSONObject jsonObject2 = JSONObject.parseObject(tag.toString());
                String code = "";
                if (jsonObject2.containsKey("code")) {
                    code = jsonObject2.getString("code");
                    if (code.startsWith("c") || code.startsWith("C")) {
                        code = code.replaceFirst("c", "");
                    }
                }
                //如果传入标签的code为空则跳出本次循环
                if (StringUtils.isBlank(code)) {
                    continue;
                }
                //根据code或权重查询图像
                String finalCode = code;
                Optional<MenuTagsEntity> first = menus.stream().filter(x -> finalCode.equals(x.getCode())).findFirst();
                if (first.isPresent()) {
                    list.add(first.get().getId());
                }
            }
        }
        return list;
    }

}
