package com.weface.serviceimpl;

import cn.hutool.json.JSONUtil;
import com.weface.component.GeTuiSDK;
import com.weface.dto.MsgDTO;
import com.weface.service.AsyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
@Service
@Slf4j
public class AsyncServiceImpl implements AsyncService {

    @Autowired
    private GeTuiSDK geTuiSDK;

    @Override
    @Async
    public void batchPush(List<MsgDTO> objs,String fromApp) throws Exception {
        geTuiSDK.batchPush(objs,fromApp);
    }

    @Override
    @Async
    public void pushSingle(MsgDTO param) {
        log.info("单推请求:{}", JSONUtil.toJsonPrettyStr(param));
        geTuiSDK.pushSingle(param.getFromApp()+"_"+param.getUserId(),param.getTitle(),param.getBody());
    }
}
