package com.weface.controller;


import com.weface.common.utils.Model;
import com.weface.common.utils.PageUtils;
import com.weface.component.MenuService;
import com.weface.dto.UserTagFrom;
import com.weface.service.MenuTagsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.Map;


/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@RestController
@RequestMapping("/tags/menuTags")
public class MenuTagsController {
    @Autowired
    private MenuTagsService menuTagsService;
    @Autowired
    private MenuService menuService;

    /**
     * 标签列表 可模糊查询根据levelThird
     */
    @PostMapping("/list")
    public Model list(@RequestBody Map<String, Object> params) {
        PageUtils page = menuTagsService.queryPage(params);
        return Model.ok(page);
    }

    /**
     * 根据用户giUid先调个推拿到code后走数据库拿到数据并更新相关数据后返回
     */
    @PostMapping("/queryTagByGiUid")
    public Model queryTagsByGiUid(@RequestBody UserTagFrom userTagFrom) {
        Map<String, Object> data = menuService.getUserTags(Arrays.asList(userTagFrom.getGiUidList()), null);
        return Model.ok(data);
    }

}
