//
//  SocialSecurityPaymentTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/8/1.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SocialSecurityPaymentTableViewCell.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface SocialSecurityPaymentTableViewCell ()

@property (nonatomic, strong)UILabel *lb_title;

@property (nonatomic, strong)UILabel *lb_num;

@end
@implementation SocialSecurityPaymentTableViewCell
#pragma mark - life cycle
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.lb_title];
        [self addSubview:self.lb_num];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.left.offset(23 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lb_title);
        make.right.offset(-25 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
}

#pragma mark - public methods
-(void)refreshUIWithData:(NSDictionary *)dic Array:(NSArray *)data index:(NSInteger)index
{
    if (index == 0) {
        [self.lb_title mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.offset(15 * WIDTHRADIU);
            make.left.offset(23 * WIDTHRADIU);
            make.height.offset(15 * WIDTHRADIU);
        }];
    }else if (index == (data.count - 1)){
        [self.lb_title mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.offset(10 * WIDTHRADIU);
            make.left.offset(23 * WIDTHRADIU);
            make.height.offset(15 * WIDTHRADIU);
        }];
    }
    
    
    self.lb_title.text = dic[@"title"];
    self.lb_num.text = [NSString stringWithFormat:@"¥ %@",dic[@"num"]];
}

#pragma mark - getters and setters
- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.textColor = [UIColor colorWithHex:0xb2b2b2];
        _lb_title.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_title;
}

- (UILabel *)lb_num
{
    if (!_lb_num) {
        _lb_num = [[UILabel alloc]init];
        _lb_num.textColor = [UIColor colorWithHex:0xb3b3b3];
        _lb_num.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_num;
}


- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
