//
//  CityTypeSelectView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/2.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CityTypeSelectView.h"

@interface CityTypeSelectView ()<UIPickerViewDelegate,UIPickerViewDataSource>

@property (nonatomic, strong) UIPickerView *CityTypePicker;//城市类型选择器;

@property (copy, nonatomic) NSString *title;//标题

@property (strong, nonatomic) BRCityTypeResultBlock resultBlock;

/**
 *  城市类型
 */
@property (nonatomic, strong) NSArray* cityTypes;

/**
 *  选中的城市类型
 */
@property (nonatomic, strong) NSString* selectedCityType;

@end
@implementation CityTypeSelectView
#pragma mark - life cycle
- (instancetype)initWithResultBlock:(BRCityTypeResultBlock)resultBlock
{
    self = [super init];
    if (self) {
        [self initUI];
        //设置默认选中的省份是provinces中的第一个元素
        self.selectedCityType = self.cityTypes[0];
        _resultBlock = resultBlock;
    }
    return self;
}

- (void)initUI
{
    [super initUI];
    
    
    //添加省份选择器
    [self.alertView addSubview:self.CityTypePicker];
}


#pragma mark - public methods
+ (void)showCityTypeViewWithResultBlock:(BRCityTypeResultBlock)resultBlock
{
    CityTypeSelectView *cityPicker = [[CityTypeSelectView alloc]initWithResultBlock:resultBlock];
    
    
    [cityPicker showWithAnimation:YES];
}

#pragma mark - UIPickerViewDataSource
/**
 *  一共多少咧
 *
 *  @param pickerView
 *
 *  @return
 */
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

/**
 *  返回每一列的行数
 *
 *  @param pickerView
 *  @param component
 *
 *  @return
 */
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return self.cityTypes.count;
}

//每一行的数据
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    return self.cityTypes[row];
    
}

/**
 *  选中某一行后回调 联动的关键
 *
 *  @param pickerView
 *  @param row        用户选择的省份
 *  @param component
 */
- (void)pickerView:(UIPickerView*)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
        _selectedCityType = self.cityTypes[row];
}
//返回高度
- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 35.0f;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
   
    return SCREEN_WIDTH;
}

#pragma mark - event response
- (void)clickLeftBtn
{
    [self dismissWithAnimation:YES];
}
- (void)clickRightBtn
{
    NSLog(@"点击确定按钮后,执行block回调");
    [self dismissWithAnimation:YES];
    
    NSLog(@"%@",[NSThread currentThread]);
    if (_resultBlock && _selectedCityType) {
        _resultBlock(_selectedCityType);
    }
}
- (void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    [self dismissWithAnimation:NO];
}


#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    if (animation) {
        //动画前初始位置
        CGRect rect = self.alertView.frame;
        rect.origin.y = SCREEN_HEIGHT;
        self.alertView.frame = rect;
        
        //浮现动画
        [UIView animateWithDuration:0.3 animations:^{
            CGRect rect = self.alertView.frame;
            rect.origin.y -= kDatePicHeight + kTopViewHeight;
            self.alertView.frame = rect;
        }];
    }
}

#pragma mark - 关闭视图方法
- (void)dismissWithAnimation:(BOOL)animation
{
    //关闭动画
    [UIView animateWithDuration:0.2 animations:^{
        CGRect rect = self.alertView.frame;
        rect.origin.y += kDatePicHeight + kTopViewHeight;
        self.alertView.frame = rect;
        
        self.backgroundView.alpha = 0;
    } completion:^(BOOL finished) {
        [self.leftBtn removeFromSuperview];
        [self.rightBtn removeFromSuperview];
        [self.titleLabel removeFromSuperview];
        [self.lineView removeFromSuperview];
        [self.topView removeFromSuperview];
        [self.CityTypePicker removeFromSuperview];
        [self.alertView removeFromSuperview];
        [self.backgroundView removeFromSuperview];
        [self removeFromSuperview];
        
        self.leftBtn = nil;
        self.rightBtn = nil;
        self.titleLabel  = nil;
        self.lineView = nil;
        self.topView = nil;
        self.CityTypePicker = nil;
        self.alertView = nil;
        self.backgroundView = nil;
    }];
}




#pragma mark - getters and setters
- (UIPickerView *)CityTypePicker
{
    if (!_CityTypePicker) {
        _CityTypePicker = [[UIPickerView alloc]initWithFrame:CGRectMake(0, kTopViewHeight + 0.5, SCREEN_WIDTH, kDatePicHeight)];
        _CityTypePicker.showsSelectionIndicator = YES;
        _CityTypePicker.delegate = self;
        _CityTypePicker.dataSource = self;
    }
    return _CityTypePicker;
}




- (NSArray*)cityTypes
{
    if (_cityTypes == nil) {
        
        
        _cityTypes = [NSArray arrayWithObjects:@"本地城镇",@"本地农村",@"外地城镇",@"外地农村", nil];
    }
    
    return _cityTypes;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
