//
//  CYCitySelectedView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/2.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CYCitySelectedView.h"

@interface CYCitySelectedView ()<UIPickerViewDelegate,UIPickerViewDataSource>

@property (nonatomic, strong) UIPickerView *provincePicker;//省份选择器;

@property (copy, nonatomic) NSString *title;//标题

@property (strong, nonatomic) BRCityResultBlock resultBlock;

/**
 *  plist对应的字典
 */
@property (nonatomic, strong) NSDictionary* cityNames;

/**
 *  省份
 */
@property (nonatomic, strong) NSArray* provinces;
/**
 *  城市
 */
@property (nonatomic, strong) NSArray* cities;

/**
 *  选中的省份
 */
@property (nonatomic, strong) NSString* selectedProvince;

/**
 *  选中的城市
 */
@property (nonatomic, strong) NSString* selectedCity;


@end

@implementation CYCitySelectedView
#pragma mark - life cycle
- (instancetype)initWithResultBlock:(BRCityResultBlock)resultBlock
{
    self = [super init];
    if (self) {
        [self initUI];
        //设置默认选中的省份是provinces中的第一个元素
        self.selectedProvince = self.provinces[0];
        _resultBlock = resultBlock;
    }
    return self;
}

- (void)initUI
{
    [super initUI];
    
    
    //添加省份选择器
    [self.alertView addSubview:self.provincePicker];
}


#pragma mark - public methods
+ (void)showCityViewWithResultBlock:(BRCityResultBlock)resultBlock
{
    CYCitySelectedView *cityPicker = [[CYCitySelectedView alloc]initWithResultBlock:resultBlock];
    
    
    [cityPicker showWithAnimation:YES];
}

#pragma mark - UIPickerViewDataSource
/**
 *  一共多少咧
 *
 *  @param pickerView
 *
 *  @return
 */
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 2;
}

/**
 *  返回每一列的行数
 *
 *  @param pickerView
 *  @param component
 *
 *  @return
 */
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    if (component == 0) {
        return self.provinces.count;
    }
    else {
        
        self.cities = [self.cityNames valueForKey:self.selectedProvince];
        
        return self.cities.count;
    }
}

//每一行的数据
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    //第一列返回所有的省份
    if (component == 0) {
        return self.provinces[row];
    }
    else {
        
        self.cities = [self.cityNames valueForKey:self.selectedProvince];
        
        return self.cities[row];
    }
   
}

/**
 *  选中某一行后回调 联动的关键
 *
 *  @param pickerView
 *  @param row        用户选择的省份
 *  @param component
 */
- (void)pickerView:(UIPickerView*)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    
    if (component == 0) {
        
        //选中的省份
        self.selectedProvince = self.provinces[row];
        //重新加载第二列的数据
        [pickerView reloadComponent:1];
        //让第二列归位
        [pickerView selectRow:0 inComponent:1 animated:YES];
         self.cities = [self.cityNames valueForKey:self.selectedProvince];
         _selectedCity = self.cities[0];
    }else{
        self.cities = [self.cityNames valueForKey:self.selectedProvince];
        _selectedCity = self.cities[row];
    }
}
//返回高度
- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 35.0f;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
    if (component == 0) {
        return SCREEN_WIDTH/2;
    }
    return SCREEN_WIDTH/2;
}

#pragma mark - event response
- (void)clickLeftBtn
{
    [self dismissWithAnimation:YES];
}
- (void)clickRightBtn
{
    NSLog(@"点击确定按钮后,执行block回调");
    [self dismissWithAnimation:YES];
    
    NSLog(@"%@",[NSThread currentThread]);
    if (_resultBlock && _selectedCity) {
        _resultBlock(_selectedCity);
    }
}
- (void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    [self dismissWithAnimation:NO];
}


#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    if (animation) {
        //动画前初始位置
        CGRect rect = self.alertView.frame;
        rect.origin.y = SCREEN_HEIGHT;
        self.alertView.frame = rect;
        
        //浮现动画
        [UIView animateWithDuration:0.3 animations:^{
            CGRect rect = self.alertView.frame;
            rect.origin.y -= kDatePicHeight + kTopViewHeight;
            self.alertView.frame = rect;
        }];
    }
}

#pragma mark - 关闭视图方法
- (void)dismissWithAnimation:(BOOL)animation
{
    //关闭动画
    [UIView animateWithDuration:0.2 animations:^{
        CGRect rect = self.alertView.frame;
        rect.origin.y += kDatePicHeight + kTopViewHeight;
        self.alertView.frame = rect;
        
        self.backgroundView.alpha = 0;
    } completion:^(BOOL finished) {
        [self.leftBtn removeFromSuperview];
        [self.rightBtn removeFromSuperview];
        [self.titleLabel removeFromSuperview];
        [self.lineView removeFromSuperview];
        [self.topView removeFromSuperview];
        [self.provincePicker removeFromSuperview];
        [self.alertView removeFromSuperview];
        [self.backgroundView removeFromSuperview];
        [self removeFromSuperview];
        
        self.leftBtn = nil;
        self.rightBtn = nil;
        self.titleLabel  = nil;
        self.lineView = nil;
        self.topView = nil;
        self.provincePicker = nil;
        self.alertView = nil;
        self.backgroundView = nil;
    }];
}




#pragma mark - getters and setters
- (UIPickerView *)provincePicker
{
    if (!_provincePicker) {
        _provincePicker = [[UIPickerView alloc]initWithFrame:CGRectMake(0, kTopViewHeight + 0.5, SCREEN_WIDTH, kDatePicHeight)];
        _provincePicker.showsSelectionIndicator = YES;
        _provincePicker.delegate = self;
        _provincePicker.dataSource = self;
    }
    return _provincePicker;
}

/**
 *  懒加载plist
 *
 *  @return plist对应的字典
 */
- (NSDictionary*)cityNames
{
    if (_cityNames == nil) {
        
        NSString* path = [[NSBundle mainBundle] pathForResource:@"cityData" ofType:@"plist"];
        
        _cityNames = [NSDictionary dictionaryWithContentsOfFile:path];
    }
    
    return _cityNames;
}

/**
 *  懒加载省份
 *
 *  @return 省份对应的数组
 */
- (NSArray*)provinces
{
    if (_provinces == nil) {
        
        //将省份保存到数组中  但是字典保存的是无序的 所以读出来的省份也是无序的
        _provinces = [self.cityNames allKeys];
    }
    
    return _provinces;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
