//
//  CWSqliteModelTool.h
//  CWDB
//
//  Created by 陈旺 on 2017/12/3.
//  Copyright © 2017年 Chavez. All rights reserved.

#import <Foundation/Foundation.h>
#import "CWModelProtocol.h"

typedef NS_ENUM(NSUInteger,CWDBRelationType) {
    CWDBRelationTypeMore = 0,
    CWDBRelationTypeLess,
    CWDBRelationTypeEqual,
    CWDBRelationTypeMoreEqual,
    CWDBRelationTypeLessEqual
};


@interface CWSqliteModelTool : NSObject


+ (BOOL)insertOrUpdateModel:(id)model;



+ (BOOL)insertOrUpdateModels:(NSArray<id> *)modelsArray;

+ (BOOL)insertOrUpdateModels:(NSArray<id> *)modelsArray uid:(NSString *)uid targetId:(NSString *)targetId;


+ (BOOL)insertOrUpdateModel:(id)model uid:(NSString *)uid targetId:(NSString *)targetId;


+ (NSArray *)queryAllModels:(Class)cls;


+ (NSArray *)queryModels:(Class)cls name:(NSString *)name relation:(CWDBRelationType)relation value:(id)value;

+ (NSArray *)queryModels:(Class)cls columnNames:(NSArray <NSString *>*)columnNames relations:(NSArray <NSNumber *>*)relations values:(NSArray *)values isAnd:(BOOL)isAnd;



+ (NSArray *)queryAllModels:(Class)cls uid:(NSString *)uid targetId:(NSString *)targetId;


+ (NSArray *)queryModels:(Class)cls Sql:(NSString *)sql uid:(NSString *)uid;


+ (NSArray *)queryModels:(Class)cls name:(NSString *)name relation:(CWDBRelationType)relation value:(id)value uid:(NSString *)uid targetId:(NSString *)targetId;


+ (NSArray *)queryModels:(Class)cls columnNames:(NSArray <NSString *>*)columnNames relations:(NSArray <NSNumber *>*)relations values:(NSArray *)values isAnd:(BOOL)isAnd uid:(NSString *)uid targetId:(NSString *)targetId;




+ (BOOL)deleteModel:(id)model;

+ (BOOL)deleteTableAllData:(Class)cls isKeepTable:(BOOL)isKeep;

+ (BOOL)deleteModels:(Class)cls columnName:(NSString *)name relation:(CWDBRelationType)relation value:(id)value;

+ (BOOL)deleteModels:(Class)cls columnNames:(NSArray <NSString *>*)columnNames relations:(NSArray <NSNumber *>*)relations values:(NSArray *)values isAnd:(BOOL)isAnd;



+ (BOOL)deleteTableAllData:(Class)cls uid:(NSString *)uid targetId:(NSString *)targetId isKeepTable:(BOOL)isKeep;


+ (BOOL)deleteModel:(id)model uid:(NSString *)uid targetId:(NSString *)targetId;

+ (BOOL)deleteModelWithSql:(NSString *)deleteSql uid:(NSString *)uid;

+ (BOOL)deleteModels:(Class)cls columnName:(NSString *)name relation:(CWDBRelationType)relation value:(id)value uid:(NSString *)uid targetId:(NSString *)targetId;


+ (BOOL)deleteModels:(Class)cls columnNames:(NSArray <NSString *>*)columnNames relations:(NSArray <NSNumber *>*)relations values:(NSArray *)values isAnd:(BOOL)isAnd uid:(NSString *)uid targetId:(NSString *)targetId;


+ (BOOL)updateTable:(Class)cls uid:(NSString *)uid targetId:(NSString *)targetId;

@end
