//
//  PackageCoinsView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/25.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "PackageCoinsView.h"
#import "Constants.h"
#import "UIColor+Hex.h"

static CGFloat SuccessWindow_width = 270;
static CGFloat SuccessWindow_hight = 170;

@interface PackageCoinsView ()


@property (nonatomic, strong)UIImageView *img_package;

@property (nonatomic, strong)UILabel *lb_title;

@property (nonatomic, strong)UIButton *btn_check;

@property (nonatomic, strong)UILabel *lb_num;
@property (nonatomic, strong)UIImageView *img_num;

@property (nonatomic, strong)UIButton *btn_dismiss;

@end
@implementation PackageCoinsView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self addSubview:self.img_package];
        [self addSubview:self.lb_title];
        [self addSubview:self.btn_check];
        [self addSubview:self.lb_num];
        [self addSubview:self.img_num];
        [self addSubview:self.btn_dismiss];
        self.backgroundColor = [UIColor clearColor];
        [self configSubviews];
    }
    return self;
}
- (void)dealloc
{
    NSLog(@"PackageCoinsView已销毁");
}

- (void)configSubviews
{
    WeakSelf
    [self.img_package mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(0);
        make.centerX.equalTo(weakSelf);
    }];
    
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(300);
        make.centerX.equalTo(weakSelf);
        make.height.offset(21);
    }];
    
    [self.btn_check mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.lb_title.mas_bottom).offset(20);
        make.centerX.equalTo(weakSelf);
        make.height.offset(44);
        make.width.offset(245);
    }];
    [self.btn_dismiss mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.btn_check.mas_bottom).offset(40);
        make.centerX.equalTo(weakSelf);
    }];
    
}


#pragma mark - public methods
- (void)showAnimation
{
    [self startAnimation];
    [self startAnimation2];
}

#pragma mark - 动画
- (void)startAnimation
{
    //创建核心动画
    CABasicAnimation *anima = [CABasicAnimation animation];
    
    anima.keyPath = @"position";
    
    anima.duration = 0.8;
    
    
    anima.fromValue = [NSValue valueWithCGPoint:CGPointMake(215, 215)];
    anima.toValue = [NSValue valueWithCGPoint:CGPointMake(215, 175)];
    
   
    
    anima.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionLinear];
    
    
    CABasicAnimation *anima2 = [CABasicAnimation animation];
    anima2.keyPath = @"opacity";
    anima2.duration = 0.8;
    anima2.fromValue = [NSNumber numberWithFloat:1.0];
    anima2.toValue = [NSNumber numberWithFloat:0.0];
    anima2.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut];
   
    
    
    CAAnimationGroup *groupAnima = [CAAnimationGroup animation];
    groupAnima.animations = @[anima,anima2];
    
    groupAnima.duration = 0.8;
    groupAnima.fillMode = kCAFillModeForwards;
    groupAnima.removedOnCompletion = NO;
    [self.lb_num.layer addAnimation:groupAnima forKey:nil];
}

- (void)startAnimation2
{
    //创建核心动画
    CABasicAnimation *anima = [CABasicAnimation animation];
    
    anima.keyPath = @"position";
    
    anima.duration = 0.8;
    
    
    anima.fromValue = [NSValue valueWithCGPoint:CGPointMake(259.5, 215)];
    anima.toValue = [NSValue valueWithCGPoint:CGPointMake(259.5, 175)];
    
    
    
    anima.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionLinear];
    
    
    CABasicAnimation *anima2 = [CABasicAnimation animation];
    anima2.keyPath = @"opacity";
    anima2.duration = 0.8;
    anima2.fromValue = [NSNumber numberWithFloat:1.0];
    anima2.toValue = [NSNumber numberWithFloat:0.0];
    anima2.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut];
    
    
    
    CAAnimationGroup *groupAnima = [CAAnimationGroup animation];
    groupAnima.animations = @[anima,anima2];
    
    groupAnima.duration = 0.8;
    groupAnima.fillMode = kCAFillModeForwards;
    groupAnima.removedOnCompletion = NO;
    [self.img_num.layer addAnimation:groupAnima forKey:nil];
}

#pragma mark - event response
- (void)btnClick:(UIButton *)sender
{
    if (sender == self.btn_check) {
        self.block(YES);
    }else if (sender == self.btn_dismiss){
        self.block(NO);
    }
    
}

#pragma mark - getters and setters
- (UIImageView *)img_package
{
    if (!_img_package) {
        _img_package = [[UIImageView alloc]init];
        _img_package.image = [UIImage imageNamed:@"Socialsecuritycertification_success_news_giftbox_normal"];
    }
    return _img_package;
}

- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"赚金币大礼包";
        _lb_title.textColor = [UIColor colorWithHex:0xfed052];
        _lb_title.font = [UIFont boldSystemFontOfSize:21];
    }
    return _lb_title;
}

- (UIButton *)btn_check
{
    if (!_btn_check) {
        _btn_check = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_check setTitle:@"立即查看" forState:UIControlStateNormal];
        [_btn_check setTitleColor: [UIColor colorWithHex:0xfed052] forState:UIControlStateNormal];
        CAGradientLayer *gradientLayer =  [CAGradientLayer layer];
        gradientLayer.frame = CGRectMake(0, 0, 245, 44);
        gradientLayer.startPoint = CGPointMake(0, 0);
        gradientLayer.endPoint = CGPointMake(0, 1);
        gradientLayer.locations = @[@(0),@(0.5)];//渐变点
        [gradientLayer setColors:@[(id)[[UIColor colorWithHex:0xfe7058] CGColor],(id)[[UIColor colorWithHex:0xfe4f35] CGColor]]];//渐变数组
        [_btn_check.layer addSublayer:gradientLayer];
        
        _btn_check.layer.cornerRadius = 22;
        _btn_check.layer.masksToBounds = YES;
        
        [_btn_check addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return _btn_check;
}

- (UILabel *)lb_num
{
    if (!_lb_num) {
        _lb_num = [[UILabel alloc]initWithFrame:CGRectMake(175, 195, 80, 40)];
        _lb_num.text = @"+100";
        _lb_num.font = [UIFont systemFontOfSize:32];
        _lb_num.textColor = [UIColor colorWithHex:0xfed052];
    }
    return _lb_num;
}
- (UIImageView *)img_num
{
    if (!_img_num) {
        _img_num = [[UIImageView alloc]initWithFrame:CGRectMake(247, 207, 25, 16)];
        _img_num.image = [UIImage imageNamed:@"金币"];
    }
    return _img_num;
}

- (UIButton *)btn_dismiss
{
    if (!_btn_dismiss) {
        _btn_dismiss = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_dismiss setImage:[UIImage imageNamed:@"关闭"] forState:UIControlStateNormal];
        [_btn_dismiss addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_dismiss;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
