//
//  LogTopView.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/6/29.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "LogTopView.h"
#import <Masonry.h>
#import "Constants.h"
#import "UIColor+Hex.h"
#import "PopView.h"
#import "UIImageView+WebCache.h"

@interface LogTopView ()
@property  (nonatomic, strong) UIImageView *img_UserAvatars;
@property (nonatomic, strong) UILabel *lb_NickName;

@property (nonatomic, strong)UIImageView *img_sign;

@property (nonatomic, strong) PopView *popView;
@property (nonatomic, strong) UILabel *lb_allCoinsNumber;
@property (nonatomic, strong) UILabel *lb_mycoin;
@property (nonatomic, strong) UIView *divideLine;

@property (nonatomic, strong) UILabel *lb_todayCoinsNumber;
@property (nonatomic, strong) UILabel *lb_todayCoin;

@property (nonatomic, strong) UIButton *btn_left;

@property (nonatomic, strong) UIButton *btn_right;



@end

@implementation LogTopView
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self addSubview:self.img_UserAvatars];
        [self addSubview:self.lb_NickName];
        [self addSubview:self.img_sign];
        [self addSubview:self.lb_allCoinsNumber];
        [self addSubview:self.lb_mycoin];
        [self addSubview:self.divideLine];
        [self addSubview:self.lb_todayCoinsNumber];
        [self addSubview:self.lb_todayCoin];
        [self addSubview:self.popView];
        [self addSubview:self.btn_left];
        [self addSubview:self.btn_right];
        [self setUpUI];
        
    }
    return self;
}

- (void)setUpUI
{
     __weak __typeof__(self) weakSelf = self;
    [self.img_UserAvatars mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(weakSelf.mas_centerX);
        make.top.equalTo(weakSelf.mas_top).offset(10 * WIDTHRADIU);
        make.height.offset(60 * WIDTHRADIU);
        make.width.offset(60 * WIDTHRADIU);
    }];
    
    [self.lb_NickName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.img_UserAvatars);
        make.top.equalTo(self.img_UserAvatars.mas_bottom).offset(5*WIDTHRADIU);
    }];
    
    
    [self.img_sign mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.top.offset(0);
    }];
    
    [self.lb_allCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX).multipliedBy(0.5);
        make.top.equalTo(self.lb_NickName.mas_bottom).offset(14 * WIDTHRADIU);
    }];
    [self.lb_mycoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_allCoinsNumber);
        make.top.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(5 * WIDTHRADIU);
    }];
    
    [self.divideLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(4 * WIDTHRADIU);
        make.height.offset(35 * WIDTHRADIU);
        make.width.offset(0.5);
    }];
    [self.lb_todayCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX).multipliedBy(1.5);
        make.centerY.equalTo(self.lb_allCoinsNumber);
    }];
    [self.lb_todayCoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_todayCoinsNumber);
        make.centerY.equalTo(self.lb_mycoin);
    }];
    
    
    UIFont *fnt = [UIFont fontWithName:@"HelveticaNeue" size:8.0f];
    CGSize size = CGSizeMake(SCREEN_WIDTH,8);
    CGSize labSize = [@"约1.02元" sizeWithFont:fnt constrainedToSize:size lineBreakMode:UILineBreakModeWordWrap];
    
    [self.popView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_NickName.mas_bottom).offset(0 * WIDTHRADIU);
        make.left.equalTo(self.lb_allCoinsNumber.mas_right).offset(-5);
        make.width.offset(15 + labSize.width);
        make.height.offset(15*WIDTHRADIU);
    }];
    
    [self.btn_left mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_allCoinsNumber);
        make.bottom.left.right.equalTo(self.lb_mycoin);
        
    }];
    [self.btn_right mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_todayCoinsNumber);
        make.bottom.left.right.equalTo(self.lb_todayCoin);
    }];
    
    
}

#pragma mark event response
- (void)clickAction
{
    
    if ([self.delegate respondsToSelector:@selector(tapPhotoClickWithType:)]) {
        [self.delegate tapPhotoClickWithType:@"touxiang"];
    }
}

- (void)btnclickAction:(UIButton *)sender
{
    if (sender == self.btn_left) {
        if ([self.delegate respondsToSelector:@selector(tapPhotoClickWithType:)]) {
            [self.delegate tapPhotoClickWithType:@"allcoins"];
        }
    }else if (sender == self.btn_right){
        if ([self.delegate respondsToSelector:@selector(tapPhotoClickWithType:)]) {
            [self.delegate tapPhotoClickWithType:@"todaycoins"];
        }
    }
}

#pragma mark - public methods
- (void)refreshData
{
    [_img_UserAvatars sd_setImageWithURL:[getPeopleID PeoplePhoto] placeholderImage:[UIImage imageNamed:@"my_information_headportrait_default"]];
    _lb_NickName.text = [getPeopleID Peopletitle] ? [getPeopleID Peopletitle] :  @"吃铜锣烧的小孩";
    if ([getPeopleID totalCoins]) {
        NSDictionary *dic = [getPeopleID totalCoins];
        _lb_allCoinsNumber.text = [NSString stringWithFormat:@"%@",[dic[@"totalScore"] stringValue]];
        _lb_todayCoinsNumber.text = [NSString stringWithFormat:@"%@",[dic[@"todaySore"] stringValue]];
        NSString *str = [NSString stringWithFormat:@"约%@元",dic[@"caculationMoney"] ];
         UIFont *fnt = [UIFont fontWithName:@"HelveticaNeue" size:8.0f];
        CGSize size = CGSizeMake(SCREEN_WIDTH,8);
        CGSize labSize = [str sizeWithFont:fnt constrainedToSize:size lineBreakMode:UILineBreakModeWordWrap];
        
        [self.popView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.width.offset(15 + labSize.width);
            make.top.equalTo(self.lb_NickName.mas_bottom).offset(0 * WIDTHRADIU);
            make.left.equalTo(self.lb_allCoinsNumber.mas_right).offset(-5);
            make.height.offset(15*WIDTHRADIU);
        }];
        self.popView.textLabel.text = str;
    }else{
        _lb_allCoinsNumber.text = @"0";
        _lb_todayCoinsNumber.text = @"0";
        NSString *str = @"约0元";
        UIFont *fnt = [UIFont fontWithName:@"HelveticaNeue" size:8.0f];
        CGSize size = CGSizeMake(SCREEN_WIDTH,8);
        CGSize labSize = [str sizeWithFont:fnt constrainedToSize:size lineBreakMode:UILineBreakModeWordWrap];
        
        [self.popView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.width.offset(15 + labSize.width);
            make.top.equalTo(self.lb_NickName.mas_bottom).offset(0 * WIDTHRADIU);
            make.left.equalTo(self.lb_allCoinsNumber.mas_right).offset(-5);
            make.height.offset(15*WIDTHRADIU);
        }];
        self.popView.textLabel.text = str;
    }
}

#pragma mark - getters and setters
- (UIImageView *)img_UserAvatars
{
    if (!_img_UserAvatars) {
        _img_UserAvatars = [[UIImageView alloc]init];
        _img_UserAvatars.image = [UIImage imageNamed:@"my_information_headportrait_default"];
        if ([getPeopleID PeoplePhoto]) {
             [_img_UserAvatars sd_setImageWithURL:[getPeopleID PeoplePhoto] placeholderImage:[UIImage imageNamed:@"my_information_headportrait_default"]];
        }
        _img_UserAvatars.backgroundColor = [UIColor redColor];
        _img_UserAvatars.layer.cornerRadius = 30 * WIDTHRADIU;
        _img_UserAvatars.layer.masksToBounds = YES;
        
        
        UITapGestureRecognizer *click = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickAction)];
        
        _img_UserAvatars.userInteractionEnabled = YES;
        
        [_img_UserAvatars addGestureRecognizer:click];
    }
    return _img_UserAvatars;
}

- (UILabel *)lb_NickName
{
    if (!_lb_NickName) {
        _lb_NickName = [[UILabel alloc]init];
        _lb_NickName.text = [getPeopleID Peopletitle] ? [getPeopleID Peopletitle] :  @"吃铜锣烧的小孩";
        
        _lb_NickName.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
        _lb_NickName.textAlignment = NSTextAlignmentCenter;
        _lb_NickName.textColor = [UIColor colorWithHex:0x808080];
    }
    return _lb_NickName;
}

- (UIImageView *)img_sign
{
    if (!_img_sign) {
        _img_sign = [[UIImageView alloc]init];
        _img_sign.image = [UIImage imageNamed:@""];
    }
    return _img_sign;
}

- (UILabel *)lb_allCoinsNumber
{
    if (!_lb_allCoinsNumber) {
        _lb_allCoinsNumber = [[UILabel alloc]init];
        _lb_allCoinsNumber.text = @"10240";
        _lb_allCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_allCoinsNumber.textColor = [UIColor colorWithHex:0X1886d3];
        _lb_allCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_allCoinsNumber;
}

- (UILabel *)lb_mycoin
{
    if (!_lb_mycoin) {
        _lb_mycoin = [[UILabel alloc]init];
        _lb_mycoin.text = @"我的金币";
        _lb_mycoin.textColor = [UIColor colorWithHex:0x808080];
        _lb_mycoin.font = [UIFont systemFontOfSize:14*WIDTHRADIU];
        _lb_mycoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_mycoin;
}

- (UIView *)divideLine
{
    if (!_divideLine) {
        _divideLine = [[UIView alloc]init];
        _divideLine.backgroundColor = [UIColor colorWithHex:0xcccccc];
    }
    return _divideLine;
}

- (UILabel *)lb_todayCoinsNumber
{
    if (!_lb_todayCoinsNumber) {
        _lb_todayCoinsNumber = [[UILabel alloc]init];
        _lb_todayCoinsNumber.text = @"688";
        _lb_todayCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_todayCoinsNumber.textColor = [UIColor colorWithHex:0X1886d3];
        _lb_todayCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoinsNumber;
}

- (UILabel *)lb_todayCoin
{
    if (!_lb_todayCoin) {
        _lb_todayCoin = [[UILabel alloc]init];
        _lb_todayCoin.text = @"今日金币";
        _lb_todayCoin.textColor = [UIColor colorWithHex:0x808080];
        _lb_todayCoin.font = [UIFont systemFontOfSize:14*WIDTHRADIU];
        _lb_todayCoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoin;
}

- (PopView *)popView
{
    if (!_popView) {
        _popView = [[PopView alloc]init];
        _popView.hidden = YES;
        //_popView.backgroundColor = [UIColor redColor];
    }
    return _popView;
}

- (UIButton *)btn_left
{
    if (!_btn_left) {
        _btn_left = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_left addTarget:self action:@selector(btnclickAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_left;
}
- (UIButton *)btn_right
{
    if (!_btn_right) {
        _btn_right = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_right addTarget:self action:@selector(btnclickAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_right;
}

// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
//- (void)drawRect:(CGRect)rect {
//    
//    CGFloat viewWidth = rect.size.width;
//    CGFloat viewHeight = rect.size.height;
//    //1.获取图形上下文
//        CGContextRef ctx=UIGraphicsGetCurrentContext();
//         //2.绘图（画线）
//         //设置起点
//         CGContextMoveToPoint(ctx, 0, 0);
//        //设置终点
//        CGContextAddLineToPoint(ctx, viewWidth, 0);
//        CGContextAddLineToPoint(ctx, <#CGFloat x#>, <#CGFloat y#>)
//         //渲染
//         CGContextStrokePath(ctx);
//}


@end
