//
//  LogTableViewCell.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/7/2.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "LogTableViewCell.h"
#import "Constants.h"

@interface LogTableViewCell ()

@property (weak, nonatomic) IBOutlet UIImageView *logIcon;
@property (weak, nonatomic) IBOutlet UILabel *logTitle;
@property (weak, nonatomic) IBOutlet UIView *logLine;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logIconLeading;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logLineLeading;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logLineTrailing;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logArrowTrailing;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logTitleLeading;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logIconWidth;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *logIconHeight;


@end
@implementation LogTableViewCell


- (void)setContentsWithParams:(NSDictionary *)params hiddenLine:(BOOL)hidden
{
    NSString *imageName = params[@"imgName"];
    NSString *title = params[@"title"];
    self.logIcon.image = [UIImage imageNamed:imageName];
    self.logTitle.text = title;
    self.logLine.hidden = hidden;
    
    UIImage *image = [UIImage imageNamed:imageName];
    
    self.logIconHeight.constant = image.size.height * WIDTHRADIU;
    
    self.logIconWidth.constant = image.size.width * WIDTHRADIU;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    self.logIconLeading.constant = 30 * WIDTHRADIU;
    self.logLineLeading.constant = 20 * WIDTHRADIU;
    self.logLineTrailing.constant = 20 * WIDTHRADIU;
    self.logArrowTrailing.constant = 40 * WIDTHRADIU;
    self.logTitleLeading.constant = 10 * WIDTHRADIU;
    self.logTitle.font = [UIFont systemFontOfSize:16 * WIDTHRADIU];
    
    
    
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
