//
//  SettingTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/7/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SettingTableViewCell.h"
#import "Constants.h"
#import "UIColor+Hex.h"


@implementation SettingTableViewCell


- (void)configurationDataWith:(NSDictionary *)dic
{
    self.lb_Title.text = dic[@"title"];
    self.lb_Title.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    if (dic[@"titleColor"]) {
        self.lb_Title.textColor = [UIColor colorWithHex:0x4d4d4d];
    }
    if (dic[@"titleColorArrowShow"]) {
        NSString *colorHex = dic[@"titleColorArrowShow"];
        if ([colorHex isEqualToString:@"0x808080"]) {
            self.lb_Content_ArrowShow.textColor = [UIColor colorWithHex:0x808080];
        }else if ([colorHex isEqualToString:@"0xb3b3b3"]){
             self.lb_Content_ArrowShow.textColor = [UIColor colorWithHex:0xb3b3b3];
        }
    }
    
    if (dic[@"titleColorArrowHidden"]) {
        NSString *colorHex = dic[@"titleColorArrowHidden"];
        if ([colorHex isEqualToString:@"0x808080"]) {
            self.lb_Content_ArrowHidden.textColor = [UIColor colorWithHex:0x808080];
        }else if ([colorHex isEqualToString:@"0xb3b3b3"]){
            self.lb_Content_ArrowHidden.textColor = [UIColor colorWithHex:0xb3b3b3];
        }
    }
    self.img_Arrow.hidden = [dic[@"arrowHidden"] boolValue];
    self.img_Photo.hidden = [dic[@"PhotoHidden"] boolValue];
    
}
- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
