//
//  UPViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/7/5.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "UPViewController.h"
#import "UIColor+Hex.h"
#import "Constants.h"

@interface UPViewController ()<UITextFieldDelegate>

@property (nonatomic, strong)UITextField *tf_oldPassword;
@property (nonatomic, strong)UITextField *tf_newPassword;
@property (nonatomic, strong)UITextField *tf_newPassword2;
@property (nonatomic, strong)UIButton *btn_commit;

@end

@implementation UPViewController
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.tf_oldPassword];
    [self.view addSubview:self.tf_newPassword];
    [self.view addSubview:self.tf_newPassword2];
    [self.view addSubview:self.btn_commit];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.tf_oldPassword mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(33 * WIDTHRADIU);
        make.left.offset(10);
        make.right.offset(-10);
        make.height.offset(40 * WIDTHRADIU);
    }];
    [self.tf_newPassword mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_oldPassword.mas_bottom).offset(5*WIDTHRADIU);
        make.width.centerX.height.equalTo(self.tf_oldPassword);
    }];
    [self.tf_newPassword2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_newPassword.mas_bottom).offset(5*WIDTHRADIU);
        make.width.centerX.height.equalTo(self.tf_oldPassword);
    }];
    
    [self.btn_commit mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_newPassword2.mas_bottom).offset(15 * WIDTHRADIU);
        make.width.centerX.equalTo(self.tf_oldPassword);
        make.height.offset(45 * WIDTHRADIU);
    }];
    
}

#pragma mark event response
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}

- (void)btnClick:(UIButton *)sender
{
    if (self.tf_oldPassword.text.length < 1 ) {
        [SVProgressHUD showErrorWithStatus:@"请输入原密码"];
        return;
    }
    
    if (self.tf_newPassword.text.length < 6) {
        [SVProgressHUD showErrorWithStatus:@"新密码不能少于6位"];
        return;
    }
    
    if (![self.tf_newPassword2.text isEqualToString:self.tf_newPassword.text]) {
        [SVProgressHUD showErrorWithStatus:@"两次输入密码要一致"];
        return;
    }
    
   
    [logNetModel getDidLogMessage:[getPeopleID PeopleID] andTelephone:[NSNull null] andcusName:[NSNull null]  andOldCusName:[MyMD5 md5:self.tf_oldPassword.text] andnowCusName:[MyMD5 md5:self.tf_newPassword.text]  andphoto:[NSNull null]  completionHandle:^(lodModel *model, NSError *error) {
        if ([model.code isEqualToString:@"0"]) {
            
            [getPeopleID getLoginPassword:self.tf_newPassword.text];
            
            [self.navigationController popViewControllerAnimated:YES];
        }else {
            //错误码提示
            codeSelected *code = [codeSelected MustTakeReturn:[model.status intValue]];
            [code returnCodeMethod];
        }
           
    }];
}

#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [textField resignFirstResponder];
    return YES;
}

#pragma mark - getters and setters
- (UITextField *)tf_oldPassword
{
    if (!_tf_oldPassword) {
        _tf_oldPassword = [[UITextField alloc]init];
        _tf_oldPassword.placeholder = @"请输入原密码";
        _tf_oldPassword.textColor = [UIColor colorWithHex:0x4D4D4D];
        _tf_oldPassword.borderStyle = UITextBorderStyleRoundedRect;
        _tf_oldPassword.font = [UIFont systemFontOfSize:15];
         _tf_oldPassword.delegate = self;
    }
    return _tf_oldPassword;
}

- (UITextField *)tf_newPassword
{
    if (!_tf_newPassword) {
        _tf_newPassword = [[UITextField alloc]init];
        _tf_newPassword.placeholder  = @"请输入新密码";
        _tf_newPassword.borderStyle = UITextBorderStyleRoundedRect;
        _tf_newPassword.textColor = [UIColor colorWithHex:0x4D4D4D];
        _tf_newPassword.font = [UIFont systemFontOfSize:15];
        _tf_newPassword.delegate = self;
    }
    return _tf_newPassword;
}
- (UITextField *)tf_newPassword2
{
    if (!_tf_newPassword2) {
        _tf_newPassword2 = [[UITextField alloc]init];
        _tf_newPassword2.placeholder  = @"请再次输入新密码";
        _tf_newPassword2.borderStyle = UITextBorderStyleRoundedRect;
        _tf_newPassword2.textColor = [UIColor colorWithHex:0x4D4D4D];
        _tf_newPassword2.font = [UIFont systemFontOfSize:15];
        _tf_newPassword2.delegate = self;
    }
    return _tf_newPassword2;
}

- (UIButton *)btn_commit
{
    if (!_btn_commit) {
        _btn_commit =[UIButton buttonWithType:UIButtonTypeCustom];
        _btn_commit.backgroundColor = RGBCOLOR(51, 138, 208);
        _btn_commit.titleLabel.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _btn_commit .titleLabel.textColor = [UIColor whiteColor];
        _btn_commit.layer.cornerRadius = 10;
        _btn_commit.layer.masksToBounds = YES;
        [_btn_commit setTitle:@"保存" forState:UIControlStateNormal];
        [
         _btn_commit addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    
    return _btn_commit;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
