//
//  SettingViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/7/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SettingViewController.h"
#import "SettingTableViewCell.h"
#import "Constants.h"
#import "UIImageView+WebCache.h"
#import "UIColor+Hex.h"
#import "SDImageCache.h"

#import "regardTableViewController.h"
#import "ChangeUserInfoViewController.h"
#import "UPViewController.h"
#import "loginProtocol.h"

@interface SettingViewController ()<UITableViewDelegate,UITableViewDataSource,UIImagePickerControllerDelegate,UINavigationControllerDelegate>

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)NSArray *dataArray;

@end

@implementation SettingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.view addSubview:self.tableView];
    
    UIButton *logOutBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    logOutBtn.frame = CGRectMake(0, 0, cl_kScreenWidth, 45*WIDTHRADIU);
    [logOutBtn setTitle:@"退出登录" forState:UIControlStateNormal];
    [logOutBtn setTitleColor:[UIColor colorWithHex:0x4d4d4d] forState:UIControlStateNormal];
    logOutBtn.titleLabel.font = [UIFont systemFontOfSize:17*WIDTHRADIU];
    logOutBtn.backgroundColor = [UIColor whiteColor];
    
    [logOutBtn addTarget:self action:@selector(logOutClick:) forControlEvents:UIControlEventTouchUpInside];
    self.tableView.tableFooterView = logOutBtn;
    
}

- (void)logOutClick:(UIButton *)sender
{
    
    [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"firstlog"];
    [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"secondImage"];
    [getPeopleID getpeopleLimitedAuthority:NO];
    [getPeopleID socialSate:0];
    
    //雷俊博退出时清除登录类型和账号密码
    [getPeopleID getLoginType:nil];
    [getPeopleID getLoginAccount:nil];
    [getPeopleID getLoginPassword:nil];
    [getPeopleID getTotalCoins:nil];
      self.block(YES);
    [self.navigationController popViewControllerAnimated:YES];
}


#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.dataArray.count;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    
    NSArray *array = self.dataArray[section];
    return array.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    SettingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    
    
    NSDictionary *dic = self.dataArray[indexPath.section][indexPath.row];
    
    [cell configurationDataWith:dic];
    
    if (indexPath.section == 0) {
        if (indexPath.row == 0) {
           
                 [cell.img_Photo sd_setImageWithURL:[getPeopleID PeoplePhoto] placeholderImage:[UIImage imageNamed:@"my_information_headportrait_default"]];
            
        }else if (indexPath.row == 1){
            cell.lb_Content_ArrowShow.text = [getPeopleID Peopletitle];
        }else if (indexPath.row == 2){
            cell.lb_Content_ArrowShow.text = [getPeopleID PeopleIphoneNmber];
        }else if (indexPath.row == 3){
            cell.lb_Content_ArrowShow.text = @"修改";
        }
    }else if (indexPath.section == 1){
        if (indexPath.row == 0) {
            SDImageCache *sdImageCache = [SDImageCache sharedImageCache];
            NSInteger intg = [sdImageCache getSize];
            cell.lb_Content_ArrowHidden.text =  [NSString stringWithFormat:@"%@",[self fileSizeWithInterge:intg]];
            
            
        }else if (indexPath.row == 1){
            cell.lb_Content_ArrowHidden.text = @"400-002-1709";
        }
        
        
    }
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0 && indexPath.row == 0) {
        return 55;
    }
    
    return 45;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    if (section == 1) {
        return 30;
    }
    return 10;
}
- (UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section
{
    UIView *footer = [[UIView alloc]init];
    footer.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
    return footer;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if (indexPath.section == 0 ) {
        if (indexPath.row == 0) {
            [self changeHeadView1:nil];
        }else if (indexPath.row == 1){
            
            SettingTableViewCell *cell = (SettingTableViewCell *)[tableView cellForRowAtIndexPath:indexPath];
            ChangeUserInfoViewController *vc = [ChangeUserInfoViewController new];
            vc.block = ^(BOOL isSuccess){
                if (isSuccess) {
                    [self.tableView reloadData];
                }
            };
            vc.type = CTSettingChangeUserinfoTypeNickname;
            vc.content = cell.lb_Content_ArrowShow.text;
            vc.title = @"更改昵称";
            
            [self.navigationController pushViewController:vc animated:YES];
        }else if (indexPath.row == 3){
            
            UPViewController *upVC  = [UPViewController new];
            upVC.title = @"修改密码";
            [self.navigationController pushViewController:upVC animated:YES];
        }
    }else if (indexPath.section == 1){
        if (indexPath.row == 0) {
            SDImageCache *sdImageCache = [SDImageCache sharedImageCache];
            NSInteger intg = [sdImageCache getSize];
           
            UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"清理" message:[NSString stringWithFormat:@"已清理%@缓存",[self fileSizeWithInterge:intg]] preferredStyle:UIAlertControllerStyleAlert];
            
            [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                
                NSLog(@"点击取消");
                
            }]];
            
            [alertVC addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                
                NSLog(@"点击确认");
                
                dispatch_async(dispatch_get_global_queue(0, 0), ^{
                   [[SDImageCache sharedImageCache] clearDisk];
                    
                    dispatch_async(dispatch_get_main_queue(), ^{
                        [self.tableView reloadData];
                    });
                });
                
            }]];
            
             [self presentViewController:alertVC animated:YES completion:nil];
            
        }else if (indexPath.row == 1){
           
                
                NSMutableString *str2=[[NSMutableString alloc] initWithFormat:@"tel:%@",@"400-002-1799"];
                UIWebView * callWebview = [[UIWebView alloc] init];
                [callWebview loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:str2]]];
                [self.view addSubview:callWebview];
        }else if (indexPath.row == 2){
            
            regardTableViewController *vc =[regardTableViewController sharedInstance];
            [self.navigationController pushViewController:vc animated:YES];
            
        }
    }
    
    
}


#pragma mark-照片
-(void)changeHeadView1:(UIButton *)tap
{
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"更改头像" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction *action1 = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    UIAlertAction *action2 = [UIAlertAction actionWithTitle:@"拍照" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self snapImage];
    }];
    UIAlertAction *action3 = [UIAlertAction actionWithTitle:@"从相册中上传" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            [self localPhoto];
        });
    }];
    [alert addAction:action1];
    [alert addAction:action2];
    [alert addAction:action3];
    
    [self presentViewController:alert animated:YES completion:nil];
}
-(void)snapImage
{
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        __block UIImagePickerController *ipc = [[UIImagePickerController alloc] init];
        ipc.sourceType = UIImagePickerControllerSourceTypeCamera;
        ipc.delegate = self;
        ipc.allowsEditing = YES;
        ipc.navigationBar.barTintColor =[UIColor whiteColor];
        ipc.navigationBar.tintColor = [UIColor whiteColor];
        ipc.navigationBar.titleTextAttributes = @{NSForegroundColorAttributeName:[UIColor whiteColor]};
        [self presentViewController:ipc animated:YES completion:^{
            ipc = nil;
        }];
    } else {
        NSLog(@"模拟器无法打开照相机");
    }
}
-(void)localPhoto
{
    __block UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    picker.delegate = self;
    //设置选择后的图片可被编辑
    picker.allowsEditing = YES;
    picker.navigationBar.barTintColor =[UIColor blackColor];
    picker.navigationBar.tintColor = [UIColor whiteColor];
    picker.navigationBar.titleTextAttributes = @{NSForegroundColorAttributeName:[UIColor blackColor]};
    
    
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [self presentViewController:picker animated:YES completion:^{
            picker = nil;
        }];
    });
    //主线程
    
}
-(void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    
    //完成选择
    NSString *type = [info objectForKey:UIImagePickerControllerMediaType];
    //NSLog(@"type:%@",type);
    if ([type isEqualToString:@"public.image"]) {
        //转换成NSData
        __block UIImage *image = [info objectForKey:@"UIImagePickerControllerOriginalImage"];
        if (image == nil) {
            [SVProgressHUD showErrorWithStatus:@"请在设置中打开照片访问权限"];
        }
        //关闭相册界面
        dispatch_async(dispatch_get_main_queue(), ^{
            [picker dismissViewControllerAnimated:YES completion:^{
                
                
                NSData  *dateImage1 =UIImageJPEGRepresentation(image,0.86);
                [getPeopleID getPeopleFilePhoto:dateImage1];
                
                NSString *url = [[IPDIZHI stringByAppendingString:@"/socialsecurity/kankan/uploadAccountPhoto"] stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
                
                NSDictionary *params = @{
                                         @"image":[EnercryTool encryptBase64:dateImage1],
                                         @"id":@([getPeopleID PeopleID]),
                                         @"flag":@(2)
                                         };
                
                [BaseNetManager POST2:url parameters:params completionHandler:^(id responseObj, NSError *error) {
                    if (error) {
                        [SVProgressHUD showErrorWithStatus:@"请检查您的网络!"];
                    }else{
                        NSString *code = [responseObj[@"code"] stringValue];
                        NSString *msg = responseObj[@"msg"];
                        NSString *url = responseObj[@"result"];
                        if ([code isEqualToString:@"0"]) {
                            if (msg.length > 0) {
                                [SVProgressHUD showSuccessWithStatus:msg];
                            }
                            [getPeopleID getPeoplePhoto:url];
                            
                            [self.tableView reloadData];
                        }else{
                            if (msg.length > 0) {
                                [SVProgressHUD showErrorWithStatus:msg];
                            }
                        }
                    }
                }];
                
            }];
        });
    }
}
-(void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [picker dismissViewControllerAnimated:YES completion:^{
        
    }];
}

#pragma mark - private methods
//计算缓存数据大小
//计算出大小
- (NSString *)fileSizeWithInterge:(NSInteger)size{
    // 1k = 1024, 1m = 1024k
    if (size < 1024) {// 小于1k
        return [NSString stringWithFormat:@"%ldB",(long)size];
    }else if (size < 1024 * 1024){// 小于1m
        CGFloat aFloat = size/1024;
        return [NSString stringWithFormat:@"%.0fK",aFloat];
    }else if (size < 1024 * 1024 * 1024){// 小于1G
        CGFloat aFloat = size/(1024 * 1024);
        return [NSString stringWithFormat:@"%.1fM",aFloat];
    }else{
        CGFloat aFloat = size/(1024*1024*1024);
        return [NSString stringWithFormat:@"%.1fG",aFloat];
    }
}

#pragma mark - getters and setters
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, cl_kScreenWidth, cl_kScreenHeight - cl_kNavigationBarHeight) style:UITableViewStylePlain];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        [_tableView registerNib:[UINib nibWithNibName:@"SettingTableViewCell" bundle:nil] forCellReuseIdentifier:@"cell"];
        _tableView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
    }
    return _tableView;
}

- (NSArray *)dataArray
{
    if (!_dataArray) {
        NSString *path = [[NSBundle mainBundle] pathForResource:@"SettingItemList" ofType:@"plist"];
        
        _dataArray = [NSArray arrayWithContentsOfFile:path];
    }
    
    return _dataArray;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
