//
//  ChangeUserInfoViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/7/5.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "ChangeUserInfoViewController.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface ChangeUserInfoViewController ()<UITextFieldDelegate>

@property (nonatomic, strong)UITextField *tf_ChangeContent;


@end

@implementation ChangeUserInfoViewController


#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.view addSubview:self.tf_ChangeContent];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.tf_ChangeContent.text = self.content;
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:@"提交" forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [btn sizeToFit];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:btn];;
    
    [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    [self.tf_ChangeContent mas_makeConstraints:^(MASConstraintMaker *make) {
        [self.tf_ChangeContent mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.view.mas_centerX);
            make.top.left.offset(10 * HEIGHTRADIU);
            make.right.offset(-10 * HEIGHTRADIU);
            make.height.offset(45*WIDTHRADIU);
        }];
    }];
}

#pragma mark -
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self.view endEditing:YES];
    return YES;
}

#pragma mark event reponse
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}

- (void)btnClick:(UIButton *)btn
{
    [self.view endEditing:YES];
    if (self.type == CTSettingChangeUserinfoTypeNickname) {
        if (self.tf_ChangeContent.text.length < 1) {
             [SVProgressHUD showErrorWithStatus:@"不能提交为空"];
            return;
        }
    }
    
    [logNetModel getDidLogMessage:[getPeopleID PeopleID] andTelephone:[NSNull null] andcusName: [EnercryTool encryptUseDES:self.tf_ChangeContent.text key:DESKEY]  andOldCusName:[NSNull null] andnowCusName:[NSNull null] andphoto:[NSNull null] completionHandle:^(lodModel *model, NSError *error) {
        if ([model.code isEqualToString:@"0"]) {
            [getPeopleID getPeopletitle:[EnercryTool encryptUseDES:self.tf_ChangeContent.text key:DESKEY]];
            
            self.block(YES);
            [self.navigationController popViewControllerAnimated:YES];
        }else {
            //错误码提示
            codeSelected *code = [codeSelected MustTakeReturn:[model.status intValue]];
            [code returnCodeMethod];
        }
    }];
}

#pragma mark - getters and setters
- (UITextField *)tf_ChangeContent
{
    if (!_tf_ChangeContent) {
        _tf_ChangeContent = [[UITextField alloc]init];
        _tf_ChangeContent.textColor =  [UIColor colorWithHex:0x4D4D4D];
        _tf_ChangeContent.borderStyle = UITextBorderStyleRoundedRect;
        _tf_ChangeContent.font = [UIFont systemFontOfSize:15];
        _tf_ChangeContent.delegate = self;
        if (self.type == CTSettingChangeUserinfoTypeNickname) {
            _tf_ChangeContent.placeholder = @"请输入要更换的姓名";
        }
    }
    return _tf_ChangeContent;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
