//
//  LogViewController.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/6/29.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "LogViewController.h"
#import "LogTableViewCell.h"
#import "Constants.h"
#import "LogHeaderView.h"

#import <Masonry.h>


#import "LoginVC.h"

#import "enterTableViewController.h"
#import "VoucherRecordViewController.h"
#import "SettingViewController.h"
#import "CoinsExchangeVC.h"
#import "CoinsDetailListVC.h"
#import "WithDrawViewController.h"
#import "CoinsCenterViewController.h"


//
#import "GreenChannelVC.h"


#import "LogTopView.h"

#import "XMShareView.h"
//新手引导
#import "LogGuideView.h"

#import "UIColor+Hex.h"

@interface LogViewController ()<UITableViewDelegate, UITableViewDataSource,shareViewClickDelegate,logHeaderClickDelegate>


@property (nonatomic, strong)  LogHeaderView*headerView;

@property (nonatomic, strong) UITableView *tableview;

@property (nonatomic, strong)NSArray *dataArray;

@property (nonatomic, strong)XMShareView *shareView;

@property (nonatomic, strong)UILabel *lb_title;


@end

@implementation LogViewController
#pragma mark - life cycle
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0x1886d3];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0x1886d3];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
     [self.headerView refreshData];
    
    [self refreshCoins];
    
   
    
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
   
    
    [self.view addSubview:self.tableview];
    LogHeaderView *view = self.headerView;
    self.tableview.tableHeaderView = view;
    [self.view addSubview:self.shareView];
   
   //导航栏
    self.navigationController.navigationBar.translucent = NO;
    
   
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]initWithCustomView:self.lb_title];
    
     [LogGuideView showGuideView];
}


#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    LogTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    
    NSDictionary *dic = self.dataArray[indexPath.row];
    
    BOOL hiddenLine = NO;
    if (indexPath.row == self.dataArray.count - 1) {
        
        hiddenLine = YES;
    }
    
    [cell setContentsWithParams:dic hiddenLine:hiddenLine];
    
    return cell;
}


#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 46 * WIDTHRADIU;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if (indexPath.row == 0) {
        if([[NSUserDefaults standardUserDefaults] boolForKey:@"firstlog"]){
            
            UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
            
            socialRecord*vc=[sb instantiateViewControllerWithIdentifier:@"socialRecord"];
            vc.hidesBottomBarWhenPushed =YES;
            [self.navigationController pushViewController:vc animated:YES];
            
        }
    }else if (indexPath.row == 1){
        if([[NSUserDefaults standardUserDefaults] boolForKey:@"firstlog"]){
            UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
            
            socialRecord*vc=[sb instantiateViewControllerWithIdentifier:@"socialRecord"];
            vc.record = 1;
            vc.hidesBottomBarWhenPushed =YES;
            [self.navigationController pushViewController:vc animated:YES];
        }
    }else if (indexPath.row == 2){
        if([[NSUserDefaults standardUserDefaults] boolForKey:@"firstlog"]){
            UIStoryboard *sb = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
            chooseAddressViewController*once  = [sb instantiateViewControllerWithIdentifier:@"chooseAddressViewController"];
            once.isSearch = YES;
            
            once.hidesBottomBarWhenPushed =YES;
            [self.navigationController pushViewController:once animated:YES];
        }
    }else if (indexPath.row == 3){
        [self faceToAN:self.shareView andtranslter:NO];
        
    }else if (indexPath.row == 4){
        UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
        VoucherRecordViewController *tc=[sb instantiateViewControllerWithIdentifier:@"feedbackViewController"];
        tc.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:tc animated:YES];
    }else if (indexPath.row == 5){
        if([[NSUserDefaults standardUserDefaults] boolForKey:@"firstlog"]){
            SettingViewController *settingVC = [SettingViewController new];
            settingVC.title = @"设置";
            settingVC.block = ^(BOOL isSuccess){
                if (isSuccess) {
                    self.tabBarController.selectedIndex = 0;
                }
            };
            settingVC.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:settingVC animated:YES];
        }
    }
}

#pragma mark - shareViewClickDelegate
- (void)clickWithItemType:(SHARE_ITEM)item
{
    if (item == SHARE_ITEM_WEIXIN_SESSION) {
         [self shareWebPageToPlatformType:UMSocialPlatformType_WechatSession];
    }else if (item == SHARE_ITEM_ZHIFUBAO){
         [self shareWebPageToPlatformType: UMSocialPlatformType_AlipaySession];
    }else if (item == SHARE_ITEM_QQ){
        [self shareWebPageToPlatformType: UMSocialPlatformType_QQ ];
    }else if (item == SHARE_ITEM_WEIBO){
        [UMSocialGlobal shareInstance].isUsingHttpsWhenShareContent = NO;
        [self shareWebPageToPlatformType:UMSocialPlatformType_Sina];
    }
}

#pragma mark - logHeaderClickDelegate
- (void)clickWithType:(NSString *)type
{
    if ([type isEqualToString:@"touxiang"]) {
        NSLog(@"点击头像了");
    }else if ([type isEqualToString:@"allcoins"]){
        
      
                CoinsDetailListVC *vc = [[CoinsDetailListVC alloc]init];
                vc.title = @"金币明细";
                vc.type = ListVCTypeCoinsDetail;
                vc.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:vc animated:YES];
        
    }else if ([type isEqualToString:@"todaycoins"]){
        CoinsCenterViewController *vc = [[CoinsCenterViewController alloc]init];
        vc.title = @"金币中心";
        vc.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:vc animated:YES];
//        CoinsDetailListVC *vc = [[CoinsDetailListVC alloc]init];
//        vc.title = @"我的钱包";
//        vc.type = ListVCTypeMyWallet;
//        vc.hidesBottomBarWhenPushed = YES;
//        [self.navigationController pushViewController:vc animated:YES];
    }
}

#pragma mark - call api
- (void)refreshCoins
{
    
    if ([getPeopleID PeopleID] && [getPeopleID PeopleIphoneNmber])
    {
        NSDictionary *params = @{
                              @"userId":[NSNumber numberWithInteger:[getPeopleID PeopleID]],
                              @"telephone": [EnercryTool encryptUseDES:[getPeopleID PeopleIphoneNmber] key:DESKEY]
                              };
   NSString *url =[NSString stringWithFormat:@"%@score/getpersonintegrals",CoinsBaseUrl];
        [BaseNetManager POST2:url parameters:params completionHandler:^(id responseObj, NSError *error) {
            if (responseObj) {
                NSString *code = [responseObj[@"code"] stringValue];
                if ([code isEqualToString:@"0"]) {
                    [getPeopleID getTotalCoins:responseObj[@"result"]];
                    [self.headerView refreshData];
                }
            }
        }];
    }
}


#pragma mark - private  methods
//显示动画
-(void)faceToAN:(UIView *)view1 andtranslter:(BOOL)bools;
{
    CATransition *applicationLoadViewIn =[CATransition animation];
    [applicationLoadViewIn setDuration:0.5];
    [applicationLoadViewIn setType:kCATransitionMoveIn];
    [applicationLoadViewIn setTimingFunction:[CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionDefault]];
    //you view need to replace
    [[view1 layer]addAnimation:applicationLoadViewIn forKey:kCATransitionMoveIn];
    
    [view1 reloadInputViews];
    //    [self.view reloadInputViews];
    view1.hidden=bools;
    
}

//网页分享
- (void)shareWebPageToPlatformType:(UMSocialPlatformType)platformType
{
    //创建分享消息对象
    UMSocialMessageObject *messageObject = [UMSocialMessageObject messageObject];
    
    //创建网页内容对象
    NSString* thumbURL =  UMS_THUMB_IMAGE;
    UMShareWebpageObject *shareObject = [UMShareWebpageObject shareObjectWithTitle:UMS_Title descr:UMS_Text thumImage:thumbURL];
    //设置网页地址
    shareObject.webpageUrl = UMS_WebLink;
    
    //分享消息对象设置分享内容对象
    messageObject.shareObject = shareObject;
    
    //调用分享接口
    [[UMSocialManager defaultManager] shareToPlatform:platformType messageObject:messageObject currentViewController:self completion:^(id data, NSError *error) {
        if (error) {
            UMSocialLogInfo(@"************Share fail with error %@*********",error);
        }else{
            if ([data isKindOfClass:[UMSocialShareResponse class]]) {
                UMSocialShareResponse *resp = data;
                //分享结果消息
                UMSocialLogInfo(@"response message is %@",resp.message);
                //第三方原始返回的数据
                UMSocialLogInfo(@"response originalResponse data is %@",resp.originalResponse);
                
            }else{
                UMSocialLogInfo(@"response data is %@",data);
            }
        }
        [self alertWithError:error];
    }];
}


- (void)alertWithError:(NSError *)error
{
    NSString *result = nil;
    if (!error) {
        result = [NSString stringWithFormat:@"分享成功"];
    }
    else{
        NSMutableString *str = [NSMutableString string];
        if (error.userInfo) {
            for (NSString *key in error.userInfo) {
                [str appendFormat:@"%@ = %@\n", key, error.userInfo[key]];
            }
        }
        if (error) {
            result = [NSString stringWithFormat:@"Share fail with error code: %d\n%@",(int)error.code, str];
            result = [NSString stringWithFormat:@"分享失败"];
        }
        else{
            result = [NSString stringWithFormat:@"Share fail"];
        }
    }
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:nil
                                                    message:result
                                                   delegate:nil
                                          cancelButtonTitle:NSLocalizedString(@"确定", @"确定")
                                          otherButtonTitles:nil];
    [alert show];
}
#pragma mark - getters and setters
- (LogHeaderView *)headerView
{
    if (!_headerView) {
        _headerView = [[LogHeaderView alloc]initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 202 * WIDTHRADIU)];
        _headerView.delegate = self;
    }
    return _headerView;
}

- (UITableView *)tableview
{
    if (!_tableview) {
        _tableview = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, cl_kScreenHeight - cl_kNavigationBarHeight - cl_kTabBarHeight) style:UITableViewStylePlain];
        _tableview.delegate = self;
        _tableview.dataSource = self;
        
        _tableview.separatorStyle = UITableViewCellSeparatorStyleNone;
        
        [_tableview registerNib:[UINib nibWithNibName:@"LogTableViewCell" bundle:nil] forCellReuseIdentifier:@"cell"];
        
    }
    
    return _tableview;
}

- (NSArray *)dataArray
{
    if (!_dataArray) {
        NSString *path = [[NSBundle mainBundle] pathForResource:@"LogItemList" ofType:@"plist"];
        
        _dataArray = [NSArray arrayWithContentsOfFile:path];
    }
    
    return _dataArray;
}

- (XMShareView *)shareView
{
    if (!_shareView) {
        _shareView = [[XMShareView alloc] initWithFrame:self.view.bounds];
        _shareView.delegate = self;
        _shareView.hidden = YES;
    }
    return _shareView;
}

- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"我的";
        _lb_title.textColor = [UIColor whiteColor];
        _lb_title.font = [UIFont systemFontOfSize:18*WIDTHRADIU];
        _lb_title.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_title;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
