//
//  CoinsHeaderView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsHeaderView.h"
#import "UIColor+Hex.h"
#import "Constants.h"

@interface CoinsHeaderView ()

@property (nonatomic, strong)UIView *backView;

@property (nonatomic, strong)UILabel *lb_coinsTitle;

@property (nonatomic, strong)UILabel *lb_coinsNumber;

@property (nonatomic, strong)UILabel *lb_money;

@property (nonatomic, strong)UIView *lineView;

@property (nonatomic, strong)UIImageView *img_message;

@property (nonatomic, strong)UILabel *lb_message;

@property (nonatomic, strong)UIView *bottomView;

@end
@implementation CoinsHeaderView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = RGBCOLOR(244, 244, 244);
        [self addSubview:self.backView];
        [self addSubview:self.lb_coinsTitle];
        [self addSubview:self.lb_coinsNumber];
        [self addSubview:self.lb_money];
        [self addSubview:self.lineView];
        [self addSubview:self.img_message];
        [self addSubview:self.lb_message];
        [self addSubview:self.bottomView];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.height.offset(108 * WIDTHRADIU);
    }];
    [self.lb_coinsTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.height.offset(14 * WIDTHRADIU);
    }];
    
    [self.lb_coinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.lb_coinsTitle);
        make.top.equalTo(self.lb_coinsTitle.mas_bottom).offset(8 * WIDTHRADIU);
        make.height.offset(26 * WIDTHRADIU);
    }];
    [self.lb_money mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.lb_coinsNumber.mas_right).offset(10 * WIDTHRADIU);
        make.centerY.equalTo(self.lb_coinsNumber);
    }];
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(15 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
        make.top.equalTo(self.lb_coinsNumber.mas_bottom).offset(12 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
    [self.img_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(18 * WIDTHRADIU);
        make.top.equalTo(self.lineView.mas_bottom).offset(10 * WIDTHRADIU);
    }];
    [self.lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.img_message.mas_right).offset(5 * WIDTHRADIU);
       // make.centerY.equalTo(self.img_message);
        make.top.equalTo(self.lineView.mas_bottom).offset(10 * WIDTHRADIU);
    }];
    
}


#pragma mark - public methods
- (void)refreshData
{
    NSDictionary *dic = [getPeopleID totalCoins];
    self.lb_coinsNumber.text = [getPeopleID totalCoins] ? [dic[@"totalScore"] stringValue] : @"0";
    NSString *str = [NSString stringWithFormat:@"(约%@元)",dic[@"caculationMoney"] ];
    self.lb_money.text = [getPeopleID totalCoins] ? str : @"(约0.0元)";
}
#pragma mark - getters and setters
- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc]init];
        _backView.backgroundColor = [UIColor colorWithHex:0xed8b0b];
    }
    return _backView;
}
- (UILabel *)lb_coinsTitle
{
    if (!_lb_coinsTitle) {
        _lb_coinsTitle = [[UILabel alloc]init];
        _lb_coinsTitle.text = @"我的金币:";
        _lb_coinsTitle.textColor = [UIColor whiteColor];
        _lb_coinsTitle.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
    }
    return _lb_coinsTitle;
}

- (UILabel *)lb_coinsNumber
{
    if (!_lb_coinsNumber) {
        _lb_coinsNumber = [[UILabel alloc]init];
        _lb_coinsNumber.text = @"10240";
        _lb_coinsNumber.textColor = [UIColor whiteColor];
        _lb_coinsNumber.font = [UIFont systemFontOfSize:30 * WIDTHRADIU];
    }
    return _lb_coinsNumber;
}

- (UILabel *)lb_money
{
    if (!_lb_money) {
        _lb_money = [[UILabel alloc]init];
        _lb_money.text = @"(约1.02元)";
        _lb_money.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
        _lb_money.textColor = [UIColor whiteColor];
    }
    return _lb_money;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc]init];
        _lineView.backgroundColor = [UIColor colorWithHex:0xf4f4f4];
    }
    return _lineView;
}

- (UIImageView *)img_message
{
    if (!_img_message) {
        _img_message = [[UIImageView alloc]init];
        _img_message.image = [UIImage imageNamed:@""];
    }
    return _img_message;
}

- (UILabel *)lb_message
{
    if (!_lb_message) {
        _lb_message = [[UILabel alloc]init];
        _lb_message.text = @"兑换汇率受每日收益影响会有浮动";
        _lb_message.textColor = [UIColor colorWithHex:0xfee2b8];
        _lb_message.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_message;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
