//
//  CoinsExchangeCollectionReusableView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsExchangeCollectionReusableView.h"
#import "Constants.h"
#import "UIColor+Hex.h"
#import <Masonry.h>

@implementation CoinsExchangeCollectionReusableView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self addSubview:self.lb_title];
        [self setUI];
    }
    return self;
}

- (void)setUI
{
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.left.offset(20 * WIDTHRADIU);
    }];
}


#pragma mark - getters and setters
- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"金币兑换";
        _lb_title.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_title.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_title;
}

@end
