//
//  RedPackageSuccessView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "RedPackageSuccessView.h"

#import "UIColor+Hex.h"
#import "Constants.h"

@interface RedPackageSuccessView ()

//背景蒙层视图
@property (nonatomic, strong)UIView *backgroundView;

@property (nonatomic, strong)UIView *contentView;

@property (nonatomic, strong)UIImageView *img_redPackage;

@property (nonatomic, strong)UILabel *lb_coinNum;

@property (nonatomic, strong)UILabel *lb_message1;

@property (nonatomic, strong)UIView *backView_mut;
@property (nonatomic, strong)UILabel *lb_mutNum;
@property (nonatomic, strong)UILabel *lb_mutUnit;


@property (nonatomic, strong)UILabel *lb_coinAwardNum;

@property (nonatomic, strong)UILabel *lb_message2;

@property (nonatomic, strong)UIButton *btn_confirm;

@end
@implementation RedPackageSuccessView
#pragma mark - life cycle
- (instancetype)init
{
    self = [super init];
    if (self) {
        if (self.type == RedPackageTypeNoMultiple) {
            [self initUI];
        }
        
    }
    return self;
}
- (void)initUI
{
    self.frame =ScreenBounds;
    [self addSubview:self.backgroundView];
    [self addSubview:self.contentView];
    
    [self setupUI];
}

- (void)setupUI
{
    [self.contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self).offset(-40 * WIDTHRADIU);
        make.width.offset(296 * WIDTHRADIU);
        make.height.offset(275 * WIDTHRADIU);
    }];
    
    [self.img_redPackage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.width.height.equalTo(self.contentView);
    }];
    
    [self.lb_coinNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(80 * WIDTHRADIU);
        make.centerX.equalTo(self.contentView);
        make.height.offset(30 * WIDTHRADIU);
    }];
    
    [self.lb_message1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_coinNum.mas_bottom).offset(14 * WIDTHRADIU);
        make.centerX.equalTo(self.lb_coinNum);
        make.height.offset(12 * WIDTHRADIU);
    }];
    
    [self.lb_coinAwardNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_message1.mas_bottom).offset(27 * WIDTHRADIU);
        make.centerX.equalTo(self.lb_message1);
        make.height.offset(25 * WIDTHRADIU);
    }];
    
    [self.lb_message2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_coinAwardNum.mas_bottom).offset(10 * WIDTHRADIU);
        make.centerX.equalTo(self.lb_coinAwardNum);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.btn_confirm mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_message2.mas_bottom).offset(15 * WIDTHRADIU);
        make.height.offset(40 * WIDTHRADIU);
        make.centerX.equalTo(self.lb_message2);
        make.width.offset(160 * WIDTHRADIU);
    }];
}

- (void)dealloc
{
    NSLog(@"redpackage弹框已销毁");
}

#pragma mark - public methods
+ (void)showSuccessViewWithType:(RedPackageType)type
{
    RedPackageSuccessView *view = [[RedPackageSuccessView alloc]init];
    
    view.type = type;
    
    [view showWithAnimation:YES];
}

#pragma mark - event response
-(void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    [self dismissWithAnimation:YES];
}


#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
   
    [self addAnimation];
}

-(void)addAnimation
{
    self.contentView.alpha=0;
    
    
    self.contentView.transform=CGAffineTransformMakeScale(0.02, 0.02);
    
    [UIView animateWithDuration:0.4f animations:^{
        self.contentView.transform=CGAffineTransformMakeScale(1.0, 1.0);
        self.contentView.alpha=1;
    }];
    
    
}

- (void)dismissWithAnimation:(BOOL)animation
{
    [self.lb_coinNum removeFromSuperview];
    [self.lb_message1 removeFromSuperview];
    [self.lb_coinAwardNum removeFromSuperview];
    [self.lb_message2 removeFromSuperview];
    [self.btn_confirm removeFromSuperview];
    [self.img_redPackage removeFromSuperview];
    [self.contentView removeFromSuperview];
    [self.backgroundView removeFromSuperview];
    [self removeFromSuperview];
    
    
    self.lb_coinNum = nil;
    self.lb_message1 = nil;
    self.lb_coinAwardNum = nil;
    self.lb_message2 = nil;
    self.btn_confirm = nil;
    self.img_redPackage = nil;
    self.contentView = nil;
    self.backgroundView = nil;
   
    
}


#pragma mark - getters and setters
- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:ScreenBounds];
        _backgroundView.backgroundColor = [UIColor blackColor] ;
        _backgroundView.alpha = 0.3f ;
        _backgroundView.userInteractionEnabled = YES;
        UITapGestureRecognizer *myTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(didTapBackgroundView:)];
        [_backgroundView addGestureRecognizer:myTap];
    }
    return _backgroundView;
}

- (UIView *)contentView
{
    if (!_contentView) {
        _contentView = [[UIView alloc]init];
        _contentView.backgroundColor = [UIColor clearColor];
        [_contentView addSubview:self.img_redPackage];
        [_contentView addSubview:self.lb_coinNum];
        [_contentView addSubview:self.lb_message1];
        [_contentView addSubview:self.lb_coinAwardNum];
        [_contentView addSubview:self.lb_message2];
        [_contentView addSubview:self.btn_confirm];
    }
    return _contentView;
}

- (UIImageView *)img_redPackage
{
    if (!_img_redPackage) {
        _img_redPackage = [[UIImageView alloc]init];
        _img_redPackage.image = [UIImage imageNamed:@"签到成功-礼包-短"];
    }
    return _img_redPackage;
}

- (UILabel *)lb_coinNum
{
    if (!_lb_coinNum) {
        _lb_coinNum = [[UILabel alloc]init];
        _lb_coinNum.text = @"+100";
        _lb_coinNum.textColor = [UIColor colorWithHex:0xea4f0c];
        _lb_coinNum.font = [UIFont boldSystemFontOfSize:30 * WIDTHRADIU];
    }
    return _lb_coinNum;
}

- (UILabel *)lb_message1
{
    if (!_lb_message1) {
        _lb_message1 = [[UILabel alloc]init];
        _lb_message1.text = @"恭喜签到成功";
        _lb_message1.textColor = [UIColor colorWithHex:0xf47941];
        _lb_message1.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_message1;
}

- (UIView *)backView_mut
{
    if (!_backView_mut) {
        _backView_mut = [[UIView alloc]init];
        _backView_mut.backgroundColor = [UIColor whiteColor];
        _backView_mut.layer.cornerRadius = 5 * WIDTHRADIU;
    }
    return _backView_mut;
}

- (UILabel *)lb_mutNum
{
    if (!_lb_mutNum) {
        _lb_mutNum = [[UILabel alloc]init];
        _lb_mutNum.text = @"1.5";
        _lb_mutNum.textColor = [UIColor colorWithHex:0xea4f0c];
    }
    return _lb_mutNum;
    
}

- (UILabel *)lb_coinAwardNum
{
    if (!_lb_coinAwardNum) {
        _lb_coinAwardNum = [[UILabel alloc]init];
        _lb_coinAwardNum.text = @"+50";
        _lb_coinAwardNum.textColor = [UIColor colorWithHex:0xffd27c];
        _lb_coinAwardNum.font = [UIFont boldSystemFontOfSize:25 * WIDTHRADIU];
    }
    return _lb_coinAwardNum;
}

- (UILabel *)lb_message2
{
    if (!_lb_message2) {
        _lb_message2 = [[UILabel alloc]init];
        _lb_message2.text = @"嘘~刚偷偷为你补签了一天";
        _lb_message2.textColor = [UIColor colorWithHex:0xffd27c];
        _lb_message2.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
    }
    return _lb_message2;
}

- (UIButton *)btn_confirm
{
    if (!_btn_confirm) {
        _btn_confirm = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_confirm setTitle:@"确认" forState:UIControlStateNormal];
        [_btn_confirm setTitleColor:[UIColor colorWithHex:0xe84d0d] forState:UIControlStateNormal];
        _btn_confirm.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _btn_confirm.backgroundColor = [UIColor colorWithHex:0xffd27c];
        _btn_confirm.layer.cornerRadius = 20 * WIDTHRADIU;
    }
    return _btn_confirm;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
