//
//  PXYview.h
//  Open
//
//  Created by 雷俊博 on 2019/8/8.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PXLineChartView.h"

NS_ASSUME_NONNULL_BEGIN

@interface PXYview : UIView

@property (nonatomic, strong) NSDictionary *axisAttributes;
@property (nonatomic, weak) id<PXLineChartViewDelegate>delegate;
@property (nonatomic, assign) CGFloat yElementInterval;


/**坐标转换
 
 @param yAxisValue y坐标对应的文本text
 
 @return y轴坐标位置
 */
- (CGFloat)pointOfYcoordinate:(NSString *)yAxisValue;

- (CGFloat)guidHeight:(NSString *)yAxisValue laterYxisValue:(NSString *)laterYxisValue;

- (void)refresh;
@end

NS_ASSUME_NONNULL_END
