//
//  PXXview.m
//  Open
//
//  Created by 雷俊博 on 2019/8/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "PXXview.h"

@interface PXXview ()

@property (nonatomic, strong)UIView *xlineView;

@property (nonatomic, strong)NSMutableArray *xElements;

@property (nonatomic, assign) CGFloat xElementInterval;

@property (nonatomic, assign) CGFloat xCon;

@end

@implementation PXXview
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self initialize];
    }
    return self;
}

- (void)initialize
{
    _xElementInterval = 40;
    _xlineView = UIView.new;
    _xlineView.backgroundColor = [UIColor grayColor];
    _xElements = @[].mutableCopy;
}

- (void)reset
{
    [_xElements removeAllObjects];
}

- (void)reloadXaxis {
    [self.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
    [self reset];
    if (self.axisAttriutes[yAxisColor]) {
        self.xlineView.backgroundColor = self.axisAttriutes[yAxisColor];
    }
    
    self.xlineView.frame = CGRectMake(0, 0, CGRectGetWidth(self.frame), 1);
    [self addSubview:self.xlineView];
    NSUInteger elementCons = 0;
    if (_delegate && [_delegate respondsToSelector:@selector(numberOfElementsCountWithAxisType:)]) {
        elementCons = [_delegate numberOfElementsCountWithAxisType:AxisTypeX];
    }
    if (_axisAttriutes[xElementInterval]) {
        self.xElementInterval = [_axisAttriutes[xElementInterval] floatValue];
    }
    
    for (int i = 0; i < elementCons; i++) {
        UILabel *elementView = [[UILabel alloc]init];
        if (_delegate && [_delegate respondsToSelector:@selector(elementWithAxisType:index:)]) {
            elementView = (UILabel *)[_delegate elementWithAxisType:AxisTypeX index:i];
        }
        NSDictionary *attr = @{NSFontAttributeName : elementView.font};
        CGSize elementSize = [elementView.text sizeWithAttributes:attr];
        elementView.frame = CGRectMake(0,
                                       CGRectGetHeight(self.frame)-elementSize.height,
                                       elementSize.width,
                                       elementSize.height);
        elementView.center = CGPointMake(_xElementInterval*(i+1), elementView.center.y);
        [self addSubview:elementView];
        NSString *xTitle = @"";
        if ([elementView.text length]) {
            xTitle = elementView.text;
        }
        [self.xElements addObject:xTitle];
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    [self reloadXaxis];
}

#pragma mark - public methods
- (CGFloat)pointOfXcoordinate:(NSString *)xAxisValue {
    NSUInteger xIndex = [self.xElements indexOfObject:xAxisValue];
    return (xIndex+1)*_xElementInterval;
}

- (void)refresh {
    [self setNeedsLayout];
    [self layoutIfNeeded];
}



#pragma mark - getters and setters

- (void)setDelegate:(id<PXLineChartViewDelegate>)delegate
{
    _delegate = delegate;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
