//
//  ExchangeMoneyBtn.m
//  Open
//
//  Created by 雷俊博 on 2019/8/6.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "ExchangeMoneyBtn.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface ExchangeMoneyBtn ()

/** 遮罩 */
@property (nonatomic, strong) CAShapeLayer *maskLayer;
/** 路径 */
@property (nonatomic, strong) UIBezierPath *borderPath;

@end
@implementation ExchangeMoneyBtn

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 初始化遮罩
        self.maskLayer = [CAShapeLayer layer];
        // 设置遮罩
        [self.layer setMask:self.maskLayer];
        // 初始化路径
        self.borderPath = [UIBezierPath bezierPath];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    // 遮罩层frame
    self.maskLayer.frame = self.bounds;
    
    // 设置path起点
    [self.borderPath moveToPoint:CGPointMake(self.bounds.size.height/2, self.bounds.size.height)];
    // 左上角的圆角
//    [self.borderPath addQuadCurveToPoint:CGPointMake(15 * WIDTHRADIU, 0) controlPoint:CGPointMake(0, 15 * WIDTHRADIU)];
    
    CGFloat startAngle = ((float)M_PI)/2; //
    CGFloat endAngle = -((float)M_PI)/2; ;

    [self.borderPath addArcWithCenter:CGPointMake(self.bounds.size.height/2, self.bounds.size.height/2) radius:self.bounds.size.height/2 startAngle:startAngle endAngle:endAngle clockwise:YES];
    // 直线，到右上角
    [self.borderPath addLineToPoint:CGPointMake(self.bounds.size.width, 0)];
    // 直线，到右下角
    [self.borderPath addLineToPoint:CGPointMake(self.bounds.size.width, self.bounds.size.height)];
    // 底部的小三角形
    [self.borderPath addLineToPoint:CGPointMake(self.bounds.size.height/2, self.bounds.size.height)];
    
    
    // 将这个path赋值给maskLayer的path
    self.maskLayer.path = self.borderPath.CGPath;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
