//
//  DashLineView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "DashLineView.h"
#import "UIColor+Hex.h"

@implementation DashLineView
{
    CGFloat _lineLength;
    CGFloat _lineSpacing;
    UIColor* _lineColor;
    CGFloat _height;
}

- (instancetype)initWithFrame:(CGRect)frame withLineLength:(NSInteger)lineLength withLineSpacing:(NSInteger)lineSpacing withLineColor:(UIColor *)lineColor{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor colorWithHex:0xfdf4e8];
        _lineLength = lineLength;
        _lineSpacing = lineSpacing;
        _lineColor = lineColor;
        _height = frame.size.height;
    }
    return self;
}
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
    CGContextRef context =UIGraphicsGetCurrentContext();
    CGContextBeginPath(context);
    CGContextSetLineWidth(context,1);
    CGContextSetStrokeColorWithColor(context, _lineColor.CGColor);
    CGFloat lengths[] = {_lineLength,_lineSpacing};
    CGContextSetLineDash(context, 0, lengths,2);
    CGContextMoveToPoint(context, 0, 0);
    CGContextAddLineToPoint(context, 0,self.bounds.size.height);
    CGContextStrokePath(context);
    CGContextClosePath(context);
}

@end
