//
//  CoinCenterTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/8/6.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinCenterTableViewCell.h"

#import "UIColor+Hex.h"
#import "Constants.h"

@interface CoinCenterTableViewCell ()

@property (nonatomic, strong)UILabel *lb_type;

@property (nonatomic, strong)UILabel *lb_num;

@property (nonatomic, strong)UIButton *btn_right;

@property (nonatomic, strong)UIView *lineView;

@property (nonatomic, assign)ListCoinsMissonType type;

@end
@implementation CoinCenterTableViewCell
#pragma mark - life cycle
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.lb_type];
        [self addSubview:self.lb_num];
        [self addSubview:self.btn_right];
        [self addSubview:self.lineView];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.lb_type mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_type.mas_bottom).offset(10 * WIDTHRADIU);
        make.left.equalTo(self.lb_type);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.btn_right mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.height.offset(25 * WIDTHRADIU);
        make.right.offset(-20 * WIDTHRADIU);
        make.width.offset( 70 * WIDTHRADIU);
    }];
    
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(10 * WIDTHRADIU);
        make.right.offset(-10 * WIDTHRADIU);
        make.bottom.offset(0);
        make.height.offset(0.5);
    }];
}

#pragma mark - public methods
- (void)refreshUIWithString:(NSString *)str
{
    if ([str isEqualToString:@"gz"]) {
        self.type = ListCoinsMissonTypePublic;
    }else if ([str isEqualToString:@"ts"]){
         self.type = ListCoinsMissonTypePush;
    }else if ([str isEqualToString:@"xw"]){
        self.type = ListCoinsMissonTypeNews;
    }else if ([str isEqualToString:@"tv"]){
        self.type = ListCoinsMissonTypeVideo;
    }
}
#pragma mark - getters and setters

- (void)setType:(ListCoinsMissonType)type
{
    if (type == ListCoinsMissonTypePublic) {
        self.lb_type.text = @"关注“看看社保”公众号";
        self.lb_num.text = @"+200金币";
        [self.btn_right setTitle:@"去关注" forState:UIControlStateNormal];
        [self.btn_right setTitleColor:[UIColor colorWithHex:0xfa9504] forState:UIControlStateNormal];
        self.btn_right.layer.borderWidth = 1.0;
        self.btn_right.layer.borderColor = [UIColor colorWithHex:0xfa9504].CGColor;
        self.btn_right.layer.cornerRadius = 12 * WIDTHRADIU;
        self.btn_right.layer.masksToBounds = YES;
        
    }else if (type == ListCoinsMissonTypePush){
        self.lb_type.text = @"打开APP推送权限";
        self.lb_num.text = @"+50金币";
        [self.btn_right setTitle:@"去开启" forState:UIControlStateNormal];
        [self.btn_right setTitleColor:[UIColor colorWithHex:0xfa9504] forState:UIControlStateNormal];
        self.btn_right.layer.borderWidth = 1.0;
        self.btn_right.layer.borderColor = [UIColor colorWithHex:0xfa9504].CGColor;
        self.btn_right.layer.cornerRadius = 12 * WIDTHRADIU;
        self.btn_right.layer.masksToBounds = YES;
    }else if (type == ListCoinsMissonTypeNews){
        self.lb_type.text = @"阅读“新闻头条”";
        self.lb_num.text = @"+50金币";
        [self.btn_right setTitle:@"领取金币" forState:UIControlStateNormal];
        [self.btn_right setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        self.btn_right.backgroundColor = [UIColor colorWithHex:0xfa9504];
        self.btn_right.layer.cornerRadius = 12 * WIDTHRADIU;
        self.btn_right.layer.masksToBounds = YES;
    }else if (type == ListCoinsMissonTypeVideo){
        self.lb_type.text = @"观看“短视频”";
        self.lb_num.text = @"+50金币";
        [self.btn_right setTitle:@"去观看" forState:UIControlStateNormal];
        [self.btn_right setTitleColor:[UIColor colorWithHex:0xfa9504] forState:UIControlStateNormal];
        self.btn_right.layer.borderWidth = 1.0;
        self.btn_right.layer.borderColor = [UIColor colorWithHex:0xfa9504].CGColor;
        self.btn_right.layer.cornerRadius = 12 * WIDTHRADIU;
        self.btn_right.layer.masksToBounds = YES;
    }
}
- (UILabel *)lb_type
{
    if (!_lb_type) {
        _lb_type = [[UILabel alloc]init];
        _lb_type.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_type.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_type;
}

- (UILabel *)lb_num
{
    if (!_lb_num) {
        _lb_num = [[UILabel alloc]init];
        _lb_num.textColor = [UIColor colorWithHex:0xfa9504];
        _lb_num.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
    }
    return _lb_num;
}

- (UIButton *)btn_right
{
    if (!_btn_right) {
        _btn_right = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_right.titleLabel.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _btn_right;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc]init];
        _lineView.backgroundColor = [UIColor colorWithHex:0xe6e6e6];
    }
    return _lineView;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
