//
//  AuthenticationGuideView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/9.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "AuthenticationGuideView.h"

#import "UIColor+Hex.h"
#import "Constants.h"

@interface AuthenticationGuideView ()

@property (nonatomic, strong)UIView *backgroundView;

@property (nonatomic, strong)UIView *whiteView;

@property (nonatomic, strong)UILabel *lb_title;

@property (nonatomic, strong)UILabel *lb_message;

@property (nonatomic, strong)UIView *lineView_H;

@property (nonatomic, strong)UIView *lineView_V;

@property (nonatomic, strong)UIButton *btn_confirm;

@property (nonatomic, strong)UIButton *btn_cancel;


@property (nonatomic, strong)UIImageView *img_Arrow;

@property (nonatomic, strong)UIImageView *img_circle;

@property (nonatomic, strong)UILabel *lb_imgTitle;


@end

@implementation AuthenticationGuideView
- (instancetype)initWithBlock:(BtnClickClock)block
{
    self = [super init];
    if (self) {
        [self initUI];
        self.block = block;
    }
    return self;
}

- (void)initUI
{
    self.frame =ScreenBounds;
    [self addSubview:self.backgroundView];
    [self addSubview:self.whiteView];
    
    [self addSubview:self.img_Arrow];
    [self addSubview:self.img_circle];
    [self addSubview:self.lb_imgTitle];
    
    [self setupUI];
    
}

- (void)dealloc
{
    NSLog(@"认证提示界面销毁了");
}

- (void)setupUI
{
   

    [self.img_circle  mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(470 + cl_kNavigationBarHeight);
        make.left.offset(150 );
        make.width.offset(ScreenWidth - 151);
        make.height.offset(70 * WIDTHRADIU );
    }];
    
    if (ScreenHeight >667) {
        [self.img_Arrow mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.img_circle.mas_top).offset(-5);
            make.centerX.equalTo(self.whiteView).offset(70 * WIDTHRADIU);
            make.width.offset(18 );
            make.height.offset(100.5);
        }];
        
        [self.lb_imgTitle mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.img_Arrow.mas_left);
            make.bottom.equalTo(self.img_circle.mas_top).offset(-30);
            
        }];
    }else {
        [self.img_Arrow mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.img_circle.mas_top).offset(-5);
            make.centerX.equalTo(self.whiteView).offset(20 * WIDTHRADIU);
            make.width.offset(78  );
            make.height.offset(177);
        }];
        
        [self.lb_imgTitle mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.img_Arrow.mas_right).offset(-60);
             make.bottom.equalTo(self.img_circle.mas_top).offset(-50);
            
        }];
    }
    
    [self.whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.bottom.equalTo(self.img_Arrow.mas_top);
        make.width.offset(250 * WIDTHRADIU);
        make.height.offset(150 * WIDTHRADIU);
    }];
}

#pragma mark - public methods
+ (void)showGuideViewBlock:(BtnClickClock)block
{
    AuthenticationGuideView *showView = [[AuthenticationGuideView alloc]initWithBlock:block];
    
    [showView showWithAnimation:YES];
}

#pragma mark - event response
-(void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    //[self dismissWithAnimation:YES];
}

- (void)btnClick:(UIButton *)sender
{
    if (sender == self.btn_confirm) {
        self.block(YES);
    }else if (sender == self.btn_cancel){
        self.block(NO);
    }
    
    [self dismissWithAnimation:YES];
   
}
#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    
    [self addAnimation];
    
}

-(void)addAnimation
{
    self.whiteView.alpha=0;
    
    
    self.whiteView.transform=CGAffineTransformMakeScale(0.02, 0.02);
    
    
    [UIView animateWithDuration:0.4f animations:^{
        self.whiteView.transform=CGAffineTransformMakeScale(1.0, 1.0);
        self.whiteView.alpha=1;
      
    }];
    
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.whiteView);
        make.top.offset(20 * WIDTHRADIU);
        make.height.offset(19 * WIDTHRADIU);
    }];
    
    [self.lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.whiteView);
        make.top.equalTo(self.lb_title.mas_bottom).offset(15 * WIDTHRADIU);
        make.height.offset(35 * WIDTHRADIU);
    }];
    
    [self.lineView_H mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_message.mas_bottom).offset(15 * WIDTHRADIU);
        make.centerX.equalTo(self.whiteView);
        make.left.right.offset(0);
        make.height.offset(0.5);
    }];
    
    [self.lineView_V mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lineView_H.mas_bottom);
        make.bottom.equalTo(self.whiteView);
        make.width.offset(0.5);
        make.centerX.equalTo(self.whiteView);
    }];
    
    [self.btn_confirm mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lineView_H.mas_bottom);
        make.left.equalTo(self.whiteView);
        make.right.equalTo(self.lineView_V.mas_left);
        make.bottom.equalTo(self.whiteView);
    }];
    
    [self.btn_cancel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lineView_H.mas_bottom);
        make.right.equalTo(self.whiteView);
        make.left.equalTo(self.lineView_V.mas_right);
        make.bottom.equalTo(self.whiteView);
    }];
    
}

- (void)dismissWithAnimation:(BOOL)animation
{
    
    
   
   
    [self.whiteView removeFromSuperview];
    [self.backgroundView removeFromSuperview];
    [self.img_Arrow removeFromSuperview];
    [self.img_circle removeFromSuperview];
    [self.lb_imgTitle removeFromSuperview];
    [self removeFromSuperview];
    
    
    
    self.backgroundView = nil;
    self.whiteView = nil;
    self.img_Arrow = nil;
    self.img_circle = nil;
    self.lb_imgTitle = nil;
    
}
#pragma mark - getters and setters


//
//- (UIImageView *)img_Success
//{
//    if (!_img_Success) {
//        _img_Success = [[UIImageView alloc]init];
//        _img_Success.image = [UIImage imageNamed:@"签到成功"];
//    }
//    return _img_Success;
//}
- (UIView *)whiteView
{
    if (!_whiteView) {
        _whiteView = [[UIView alloc]init];
        _whiteView.backgroundColor = [UIColor whiteColor];
        _whiteView.layer.cornerRadius = 15 * WIDTHRADIU;
        _whiteView.layer.masksToBounds = YES;
        [_whiteView addSubview:self.lb_title];
        [_whiteView addSubview:self.lb_message];
        [_whiteView addSubview:self.lineView_H];
        [_whiteView addSubview:self.lineView_V];
        [_whiteView addSubview:self.btn_confirm];
        [_whiteView addSubview:self.btn_cancel];
        [_whiteView addSubview:self.lb_imgTitle];
    }
    return _whiteView;
}

- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"退出认证";
        _lb_title.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_title.textAlignment = NSTextAlignmentCenter;
        _lb_title.font = [UIFont systemFontOfSize:19 * WIDTHRADIU];
    }
    return _lb_title;
}

- (UILabel *)lb_message
{
    if (!_lb_message) {
        _lb_message = [[UILabel alloc]init];
        _lb_message.text = @"您还没有认证完成\n确定中途退出";
        _lb_message.numberOfLines = 0;
        _lb_message.textAlignment = NSTextAlignmentCenter;
        _lb_message.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
        _lb_message.textColor = [UIColor colorWithHex:0x808080];
    }
    return _lb_message;
}

- (UIView *)lineView_H
{
    if (!_lineView_H) {
        _lineView_H = [[UIView alloc]init];
        _lineView_H.backgroundColor = [UIColor colorWithHex:0xcccccc];
    }
    return _lineView_H;
}


- (UIView *)lineView_V
{
    if (!_lineView_V) {
        _lineView_V = [[UIView alloc]init];
        _lineView_V.backgroundColor = [UIColor colorWithHex:0xcccccc];
    }
    return _lineView_V;
}

- (UIButton *)btn_confirm
{
    if (!_btn_confirm) {
        _btn_confirm = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_confirm setTitle:@"确定退出" forState:UIControlStateNormal];
        [_btn_confirm setTitleColor:[UIColor colorWithHex:0x1886d3] forState:UIControlStateNormal];
        _btn_confirm.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        
        [_btn_confirm addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_confirm;
}

- (UIButton *)btn_cancel
{
    if (!_btn_cancel) {
        _btn_cancel = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_cancel setTitle:@"不" forState:UIControlStateNormal];
        [_btn_cancel setTitleColor:[UIColor colorWithHex:0x1886d3] forState:UIControlStateNormal];
        _btn_cancel.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
         [_btn_cancel addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_cancel;
}

- (UIImageView *)img_Arrow
{
    if (!_img_Arrow) {
        _img_Arrow = [[UIImageView alloc]init];
        if (ScreenHeight > 667) {
            _img_Arrow.image = [UIImage imageNamed:@"箭头-短"];
        }else{
            _img_Arrow.image = [UIImage imageNamed:@"Home_Certification_dropout_Pop-ups_undone_Pointingarrow_normal"];
        }
        
    }
    return _img_Arrow;
}

- (UIImageView *)img_circle
{
    if (!_img_circle) {
        _img_circle = [[UIImageView alloc]init];
        _img_circle.image = [UIImage imageNamed:@"Home_Certification_dropout_Pop-ups_undone_circle_normal"];
    }
    return _img_circle;
}

- (UILabel *)lb_imgTitle
{
    if (!_lb_imgTitle) {
        _lb_imgTitle = [[UILabel  alloc]init];
        _lb_imgTitle.text = @"确认参保信息无误后\n选择下一步继续认证";
        _lb_imgTitle.textColor = [UIColor whiteColor];
        _lb_imgTitle.font = [UIFont systemFontOfSize:17];
        _lb_imgTitle.numberOfLines = 0;
    }
    return _lb_imgTitle;
}

//- (UILabel *)lb_message
//{
//    if (!_lb_message) {
//        _lb_message = [[UILabel alloc]init];
//        _lb_message.text = @"偷偷告诉你，满签奖励多多";
//        _lb_message.textColor = [UIColor colorWithHex:0x808080];
//        _lb_message.font = [UIFont systemFontOfSize:14 *WIDTHRADIU];
//    }
//    return _lb_message;
//}
//
//- (UILabel *)lb_num
//{
//    if (!_lb_num) {
//        _lb_num = [[UILabel alloc]init];
//        _lb_num.text = @"+30";
//        _lb_num.textColor = [UIColor colorWithHex:0xfa9502];
//        _lb_num.font = [UIFont systemFontOfSize:29 *WIDTHRADIU];
//    }
//    return _lb_num;
//}
- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:ScreenBounds];
        _backgroundView.backgroundColor = [UIColor colorWithHex:0x323232 alpha:0.8];;
        _backgroundView.alpha = 0.6f ;
        _backgroundView.userInteractionEnabled = YES;
        UITapGestureRecognizer *myTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(didTapBackgroundView:)];
        [_backgroundView addGestureRecognizer:myTap];
    }
    return _backgroundView;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
