//
//  InsuredMemberAddViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/8/5.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "InsuredMemberAddViewController.h"

#import "UIColor+Hex.h"
#import "UIImage+Custom.h"
#import "Constants.h"

#import "InsuredMemberAddTableViewCell.h"


@interface InsuredMemberAddViewController ()<UITableViewDelegate,UITableViewDataSource,UITextFieldDelegate,UITextViewDelegate>
{
    CGPoint _editOffset;
    
    CGFloat _editHeight;
}

@property (nonatomic, strong)UIView *topView;
@property (nonatomic, strong)UIView *topBackView;
@property (nonatomic, strong)UIView *leftView;
@property (nonatomic, strong)UIImageView *img_leftTop;
@property (nonatomic, strong)UIImageView *img_leftBottom;
@property (nonatomic,strong)UIImageView *img_rightBottom;
@property (nonatomic, strong)UIImageView *img_rightTop;
@property (nonatomic, strong)UIImageView *img_Front;
@property (nonatomic, strong)UILabel *lb_uploadTitle;
@property (nonatomic, strong)UIButton *btn_left;

@property (nonatomic, strong)UIView *rightView;
@property (nonatomic, strong)UIImageView *img2_leftTop;
@property (nonatomic, strong)UIImageView *img2_leftBottom;
@property (nonatomic,strong)UIImageView *img2_rightBottom;
@property (nonatomic, strong)UIImageView *img2_rightTop;
@property (nonatomic, strong)UIImageView *img_Back;
@property (nonatomic, strong)UILabel *lb2_uploadTitle;
@property (nonatomic, strong)UIButton *btn_right;

@property (nonatomic, strong)UILabel *lb_title;



@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)UIScrollView *scrollview;

@property (nonatomic, strong)UIView *bottomView;
@property (nonatomic, strong)NSArray *titleArray;

@property (nonatomic, assign)CGPoint lastContentOffset;



@end

@implementation InsuredMemberAddViewController
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
    //[self.view addSubview:self.scrollview];
    [self.view addSubview:self.tableView];
    //起点发生变化
    self.edgesForExtendedLayout=UIRectEdgeBottom;
    
    //收起键盘的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillHide:) name:UIKeyboardWillHideNotification object:nil];

}

-(void)keyboardWillHide:(NSNotification *)note{
         [self.tableView setContentOffset:CGPointMake(0, 0) animated:YES];
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(11 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.height.offset(16 * WIDTHRADIU);
    }];
    
    CGFloat leftMargin = 10 * WIDTHRADIU;
    CGFloat middleMargin = 11 * WIDTHRADIU;
    CGFloat rightMargin = 10 * WIDTHRADIU;
    CGFloat width = (SCREEN_WIDTH - leftMargin - middleMargin - rightMargin)/2;
    CGFloat scale = 230/344.0;
    CGFloat height = width * scale;
    
    [self.leftView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(10 * WIDTHRADIU);
        make.top.equalTo(self.lb_title.mas_bottom).offset(9 * WIDTHRADIU);
        make.width.offset(width);
        make.height.offset(height);
    }];
    
    [self.img_leftTop mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.left.offset(15 * WIDTHRADIU);
    }];
    [self.img_leftBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.offset(-10 * WIDTHRADIU);
        make.left.offset(15 * WIDTHRADIU);
    }];
    [self.img_rightBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.offset(-10 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
    }];
    [self.img_rightTop mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
    }];
    
    [self.lb_uploadTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.img_Front.mas_bottom).offset(4 * WIDTHRADIU);
        make.centerX.equalTo(self.leftView);
        make.height.offset(12 * WIDTHRADIU);
    }];
    
    CGFloat imgWidth = 84 * WIDTHRADIU;
    CGFloat imgSizeScale = 104 / 168.0;
    CGFloat imgHeight = imgWidth * imgSizeScale;
    
    [self.img_Front mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.leftView);
        make.top.equalTo(self.img_leftTop.mas_bottom);
        make.width.offset(imgWidth);
        make.height.offset(imgHeight);
    }];
    
    [self.btn_left mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.img_Front);
        make.width.height.offset(25 * WIDTHRADIU);
    }];
    
    
    [self.rightView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.offset(-10 * WIDTHRADIU);
        make.top.equalTo(self.lb_title.mas_bottom).offset(9 * WIDTHRADIU);
        make.width.offset(width);
        make.height.offset(height);
    }];
    
    
    [self.img2_leftTop mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.left.offset(15 * WIDTHRADIU);
    }];
    [self.img2_leftBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.offset(-10 * WIDTHRADIU);
        make.left.offset(15 * WIDTHRADIU);
    }];
    [self.img2_rightBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.offset(-10 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
    }];
    [self.img2_rightTop mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
    }];
    
    [self.img_Back mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.rightView);
        make.top.equalTo(self.img2_leftTop.mas_bottom);
        make.width.offset(imgWidth);
        make.height.offset(imgHeight);
    }];
    
    [self.lb2_uploadTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.img_Back.mas_bottom).offset(4 * WIDTHRADIU);
        make.centerX.equalTo(self.rightView);
        make.height.offset(12 * WIDTHRADIU);
    }];
    
    [self.btn_right mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.img_Back);
        make.width.height.offset(25 * WIDTHRADIU);
    }];
    
   
}


#pragma mark - UITextFieldDelegate
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
   
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    CGRect rectInTableView = [self.tableView rectForRowAtIndexPath:indexPath];
    CGRect rectInSuperview = [self.tableView convertRect:rectInTableView toView:[self.tableView superview]];
    
     [self.tableView setContentOffset:rectInTableView.origin animated:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *)sender {
    
    // 执行动画(恢复到原始位置)
    [self.tableView setContentOffset:CGPointMake(0, 0) animated:YES];
    
    // 交出第一响应者
    [sender resignFirstResponder];
    
    return YES;
}

#pragma mark - UITextViewDelegate
- (BOOL)textViewShouldBeginEditing:(UITextView *)textView
{
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    CGRect rectInTableView = [self.tableView rectForRowAtIndexPath:indexPath];
    CGRect rectInSuperview = [self.tableView convertRect:rectInTableView toView:[self.tableView superview]];
    _editOffset = rectInTableView.origin;
    
    
    [self.tableView setContentOffset:rectInTableView.origin animated:YES];
    return YES;
}
- (void)textViewDidEndEditing:(UITextView *)textView
{
    // 执行动画(恢复到原始位置)
    [self.tableView setContentOffset:CGPointMake(0, 0) animated:YES];
    
    // 交出第一响应者
    [textView resignFirstResponder];
    
}

- (void)textViewDidChange:(UITextView *)textView
{
    // 让 table view 重新计算高度
    InsuredMemberAddTableViewCell * cell  = (InsuredMemberAddTableViewCell *)[textView superview];
    UILabel *lb = nil;
    for (UIView *view in cell.subviews) {
        if ([view isKindOfClass:[UILabel class]]) {
            lb = (UILabel *)view;
            break;
        }
    }
    
    CGSize size = CGSizeMake(ScreenWidth - 135 * WIDTHRADIU, MAXFLOAT);
    CGSize textSize = [textView.text sizeWithFont:[UIFont systemFontOfSize:15 * WIDTHRADIU] constrainedToSize:size lineBreakMode:NSLineBreakByWordWrapping];
    
    _editHeight = textSize.height;
    
    [textView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(lb.mas_right).offset(25 * WIDTHRADIU);
        make.top.offset(2.5 * WIDTHRADIU);
        make.right.offset(- 25 * WIDTHRADIU);
        make.height.offset(textSize.height > 40 * WIDTHRADIU ? textSize.height : 40 *WIDTHRADIU);
    }];
    
    NSIndexPath *indexPath1=[self.tableView indexPathForCell:cell]; //具体的某一行
    [self.tableView  beginUpdates];
    
    CGRect rectInTableView = [self.tableView rectForRowAtIndexPath:indexPath1];
   
    [self.tableView  endUpdates];
      [self.tableView setContentOffset:rectInTableView.origin animated:YES];
    
}

#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 4;
    }
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    InsuredMemberAddTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    
    cell.tf_value.delegate = self;
    cell.tv_value.delegate = self;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    if (indexPath.section == 0) {
        NSArray * array = self.titleArray[0];
        [cell refreshUIWithTitle:array[indexPath.row]];
    }else{
         [cell refreshUIWithTitle:self.titleArray[1]];
        cell.tf_value.hidden = YES;
        cell.tv_value.hidden = NO;
    }
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 1) {
       return  _editHeight > 45 * WIDTHRADIU ? _editHeight + 10 * WIDTHRADIU : 45 * WIDTHRADIU;
    }
    return 45 * WIDTHRADIU;
}



#pragma mark - event reponse
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}




#pragma mark - getters and setters
- (NSArray *)titleArray
{
    if (!_titleArray) {
        _titleArray = @[@[@"姓        名",@"民        族",@"身份证号",@"户籍地址"],@"手机号码"];
    }
    return _titleArray;
}
- (UIScrollView *)scrollview
{
    if (!_scrollview) {
        _scrollview = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, ScreenHeight - cl_kNavigationBarHeight)];
        _scrollview.contentSize = CGSizeMake(ScreenWidth, ScreenHeight+20* WIDTHRADIU);
        _scrollview.showsHorizontalScrollIndicator = NO;
        _scrollview.showsVerticalScrollIndicator = NO;
        [_scrollview addSubview:self.topView];
    }
    return _scrollview;
}

- (UITableView *)tableView
{
    if (!_tableView ) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight - cl_kNavigationBarHeight - 45 * WIDTHRADIU) style:UITableViewStylePlain];
        _tableView.showsHorizontalScrollIndicator = YES;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        _tableView.tableHeaderView = self.topView;
        _tableView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        [_tableView registerClass:[InsuredMemberAddTableViewCell class] forCellReuseIdentifier:@"cell"];
    }
    return _tableView;
}

- (UIView *)topView
{
    if (!_topView) {
        CGFloat leftMargin = 10 * WIDTHRADIU;
        CGFloat middleMargin = 11 * WIDTHRADIU;
        CGFloat rightMargin = 10 * WIDTHRADIU;
        CGFloat width = (SCREEN_WIDTH - leftMargin - middleMargin - rightMargin)/2;
        CGFloat scale = 230/344.0;
        CGFloat height = width * scale;
        _topView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, 37 *WIDTHRADIU + height)];
        _topView.backgroundColor = [UIColor whiteColor];
        [_topView addSubview:self.topBackView];
        [_topBackView addSubview:self.lb_title];
        [_topView addSubview:self.leftView];
        [_topView addSubview:self.rightView];
        [_topView addSubview:self.lb_uploadTitle];
        
    }
    return _topView;
}

- (UIView *)topBackView
{
    if (!_topBackView) {
        _topBackView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, 135 * WIDTHRADIU)];
        _topBackView.backgroundColor = [UIColor colorWithHex:0x1886d3];
       
    }
    return _topBackView;
}

- (UIView *)leftView
{
    if (!_leftView) {
        _leftView  = [[UIView alloc]init];
        _leftView.backgroundColor = [UIColor whiteColor];
        _leftView.layer.cornerRadius = 5 * WIDTHRADIU;
        [_leftView addSubview:self.img_leftTop];
        [_leftView addSubview:self.img_leftBottom];
        [_leftView addSubview:self.img_rightBottom];
        [_leftView addSubview:self.img_rightTop];
        [_leftView addSubview:self.img_Front];
        [_leftView addSubview:self.btn_left];
        
        _leftView.layer.shadowColor = [UIColor colorWithHex:0x1886d3].CGColor;
        _leftView.layer.shadowOffset = CGSizeMake(0, 1);
        _leftView.layer.shadowOpacity = 0.2;
        _leftView.layer.shadowRadius = 1 * WIDTHRADIU;
    }
    return _leftView;
}

- (UIImageView *)img_leftTop
{
    if (!_img_leftTop) {
        _img_leftTop = [[UIImageView alloc]init];
        _img_leftTop.image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
    }
    return _img_leftTop;
}
- (UIImageView *)img_leftBottom
{
    if (!_img_leftBottom) {
        _img_leftBottom = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img_leftBottom.image = [UIImage lj_imageRotatedByDegrees:-90 image:image];
    }
    return _img_leftBottom;
}
- (UIImageView *)img_rightBottom
{
    if (!_img_rightBottom) {
        _img_rightBottom = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img_rightBottom.image = [UIImage lj_imageRotatedByDegrees:-180 image:image];
    }
    return _img_rightBottom;
}

- (UIImageView *)img_rightTop
{
    if (!_img_rightTop) {
        _img_rightTop = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img_rightTop.image = [UIImage lj_imageRotatedByDegrees:-270 image:image];
    }
    return _img_rightTop;
}

- (UIImageView *)img_Front
{
    if (!_img_Front) {
        _img_Front = [[UIImageView alloc]init];
        _img_Front.image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_IDcardfront_normal"];
    }
    return _img_Front;
}

- (UILabel *)lb_uploadTitle
{
    if (!_lb_uploadTitle) {
        _lb_uploadTitle = [[UILabel alloc]init];
        _lb_uploadTitle.text = @"上传证件人像面";
        _lb_uploadTitle.textColor = [UIColor colorWithHex:0x808080];
        _lb_uploadTitle.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_uploadTitle;
}

- (UIButton *)btn_left
{
    if (!_btn_left) {
        _btn_left = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_left.backgroundColor = [UIColor colorWithHex:0x1886d3];
        [_btn_left setImage:[UIImage imageNamed:@"Socialsecuritycontributions_camera_normal"] forState:UIControlStateNormal];
        _btn_left.layer.cornerRadius = 12.5 * WIDTHRADIU;
    }
    return _btn_left;
}

- (UIView *)rightView
{
    if (!_rightView) {
        _rightView  = [[UIView alloc]init];
        _rightView.backgroundColor = [UIColor whiteColor];
        _rightView.layer.cornerRadius = 5 * WIDTHRADIU;
        [_rightView addSubview:self.img2_leftTop];
        [_rightView addSubview:self.img2_leftBottom];
        [_rightView addSubview:self.img2_rightBottom];
        [_rightView addSubview:self.img2_rightTop];
        [_rightView addSubview:self.img_Back];
        [_rightView addSubview:self.lb2_uploadTitle];
        [_rightView addSubview:self.btn_right];
        _rightView.layer.shadowColor = [UIColor colorWithHex:0x1886d3].CGColor;
        _rightView.layer.shadowOffset = CGSizeMake(0, 1);
        _rightView.layer.shadowOpacity = 0.2;
        _rightView.layer.shadowRadius = 1 * WIDTHRADIU;
    }
    return _rightView;
}

- (UIImageView *)img2_leftTop
{
    if (!_img2_leftTop) {
        _img2_leftTop = [[UIImageView alloc]init];
        _img2_leftTop.image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
    }
    return _img2_leftTop;
}
- (UIImageView *)img2_leftBottom
{
    if (!_img2_leftBottom) {
        _img2_leftBottom = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img2_leftBottom.image = [UIImage lj_imageRotatedByDegrees:-90 image:image];
    }
    return _img2_leftBottom;
}
- (UIImageView *)img2_rightBottom
{
    if (!_img2_rightBottom) {
        _img2_rightBottom = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img2_rightBottom.image = [UIImage lj_imageRotatedByDegrees:-180 image:image];
    }
    return _img2_rightBottom;
}

- (UIImageView *)img2_rightTop
{
    if (!_img2_rightTop) {
        _img2_rightTop = [[UIImageView alloc]init];
        UIImage *image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_Squarecorner_normal"];
        _img2_rightTop.image = [UIImage lj_imageRotatedByDegrees:-270 image:image];
    }
    return _img2_rightTop;
}

- (UIImageView *)img_Back
{
    if (!_img_Back) {
        _img_Back = [[UIImageView alloc]init];
        _img_Back.image = [UIImage imageNamed:@"Socialsecuritycontributions_IDUpload_ReversesideofIDcard_normal"];
    }
    return _img_Back;
}

- (UILabel *)lb2_uploadTitle
{
    if (!_lb2_uploadTitle) {
        _lb2_uploadTitle = [[UILabel alloc]init];
        _lb2_uploadTitle.text = @"上传国徽面";
        _lb2_uploadTitle.textColor = [UIColor colorWithHex:0x808080];
        _lb2_uploadTitle.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb2_uploadTitle;
}

- (UIButton *)btn_right
{
    if (!_btn_right) {
        _btn_right = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_right.backgroundColor = [UIColor colorWithHex:0x1886d3];
        [_btn_right setImage:[UIImage imageNamed:@"Socialsecuritycontributions_camera_normal"] forState:UIControlStateNormal];
        _btn_right.layer.cornerRadius = 12.5 * WIDTHRADIU;
    }
    return _btn_right;
}


- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"拍摄身份证";
        _lb_title.font = [UIFont systemFontOfSize:16 * WIDTHRADIU];
        _lb_title.textColor = [UIColor whiteColor];
    }
    return _lb_title;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
