//
//  regardTableViewController.m
//  Open
//
//  Created by 看看智能 on 2017/2/28.
//  Copyright © 2017年 黄江涛 . All rights reserved.
//

#import "regardTableViewController.h"
#import "VoucherRecordViewController.h"
#import "introduceViewController.h"
#import "SDCycleScrollView.h"
#import "NewEditionTestManager.h"
@interface regardTableViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>

@property(nonatomic,strong)UITableView *tableViews;
@property(nonatomic,strong)UIView *whiteView;
@end

@implementation regardTableViewController

+(regardTableViewController *)sharedInstance
{
    static regardTableViewController *p = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        p = [regardTableViewController new];
    });
    return p;
}









- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor =[UIColor colorWithRed:238/255.0 green:238/255.0 blue:238/255.0 alpha:1.0];
    self.title= @"关于";

    UIImageView *KKimageView =[[UIImageView alloc]init];
//    KKimageView.backgroundColor=[UIColor redColor];
    KKimageView.image =[UIImage imageNamed:@"logooooooo.png"];
        [self.view addSubview:KKimageView];
    [KKimageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(90);
        make.centerX.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(100, 100));
    }];
    UILabel *KKLabel =[[UILabel alloc]init];
    KKLabel.text=buildAndVersion;
    KKLabel.textColor =[UIColor grayColor];
    KKLabel.textAlignment=NSTextAlignmentCenter;
    [self.view addSubview:KKLabel];
    [KKLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(KKimageView.mas_bottom).mas_equalTo(20);
        make.centerX.mas_equalTo(0);
    }];

    
    
    
    self.tableViews = [[UITableView alloc]initWithFrame:self.view.frame style:UITableViewStylePlain];
    self.tableViews.backgroundColor =[UIColor whiteColor];
    self.tableViews.delegate =self;
    self.tableViews.dataSource=self;
    self.tableViews.bounces=NO;
    self.tableViews.scrollEnabled=NO;
    [self.view addSubview:self.tableViews];



    [self.tableViews mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(KKLabel.mas_bottom).mas_equalTo(20);
        make.height.mas_equalTo(100);
    }];
    
    
    
    UILabel *labelBanQuan =[[UILabel alloc]init];
    labelBanQuan.text=@"KanKan smart (shanghai) technology co.,LTD.版权所有";
    labelBanQuan.textColor =kRGBColor(187, 187, 187);
    labelBanQuan.font =[UIFont systemFontOfSize:10];
    labelBanQuan.textAlignment=NSTextAlignmentCenter;
    [self.view addSubview:labelBanQuan];
    [labelBanQuan mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.view.mas_bottom).mas_equalTo(-70);
        make.centerX.mas_equalTo(0);
    }];
    
    UILabel *labelWangzhi =[[UILabel alloc]init];
    labelWangzhi.text=@"www.weface.com.cn";
    labelWangzhi.textColor =kRGBColor(187, 187, 187);
    labelWangzhi.font =[UIFont systemFontOfSize:10];
    labelWangzhi.textAlignment=NSTextAlignmentCenter;
    [self.view addSubview:labelWangzhi];
    [labelWangzhi mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.view.mas_bottom).mas_equalTo(-50);
        make.centerX.mas_equalTo(0);
    }];
    
    
    
    
    
    
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];

}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 2;

}


-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"MyCell"];
    if (cell == nil) {
        cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"MyCell"];
    }
    switch (indexPath.row) {
 
        case 0:
            cell.textLabel.text =@"版本更新";
            cell.accessoryType=UITableViewCellAccessoryDisclosureIndicator;
            break;
            case 1:
            cell.textLabel.text =@"功能介绍";
            cell.accessoryType=UITableViewCellAccessoryDisclosureIndicator;
            break;
        default:
            break;
    }
    return cell;
}
-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
   if(indexPath.row ==0){
//        UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
//        VoucherRecordViewController *tc=[sb instantiateViewControllerWithIdentifier:@"feedbackViewController"];
//        [self.navigationController pushViewController:tc animated:YES];
       
       
       NSString *message = @"";
       if ([self isNeedUpdateVersion]) {
           message = @"有新版本，请更新到最新版本！！！";
       }else{
           message = @"已是最新版本！！！";
       }
       
       UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
       
       if ([self isNeedUpdateVersion]) {
           [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
               
               NSLog(@"点击取消");
               
           }]];
       }
       
                                     
       [alertVC addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
           
           NSLog(@"点击确认");
           
           if ([self isNeedUpdateVersion]) {
               [NewEditionTestManager getAppStoreVersion:@"1227583739"];
           }
           
       }]];
                                     
        [self presentViewController:alertVC animated:YES completion:nil];
       
        
    }else if (indexPath.row == 1){
        introduceViewController *introduce =[[introduceViewController alloc ]init];;
          introduce.hidesBottomBarWhenPushed=YES;
        [self.navigationController pushViewController:introduce animated:YES];
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 50;
    
}


#pragma mark - private methods
- (BOOL)isNeedUpdateVersion {
    NSString *urlStr = [NSString stringWithFormat:@"https://itunes.apple.com/cn/lookup?id=%@", @"1227583739"];
    NSString *infoStr = [NSString stringWithContentsOfURL:[NSURL URLWithString:urlStr] encoding:NSUTF8StringEncoding error:nil];
    NSData *jsonData = [infoStr dataUsingEncoding:NSUTF8StringEncoding];
    NSError *err;
    NSDictionary *dic  = nil;
    if (jsonData) {
            dic = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:&err];
    }
    if (err) {
        NSLog(@"json解析失败：%@",err);
        return NO;
    }
    NSString *appStoreVersion = [dic[@"results"] firstObject][@"version"]; //获取App Store版本号
    NSString *currentVersion = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"];  //获取本地版本号
    NSMutableArray *currentItems = [[currentVersion componentsSeparatedByString:@"."] mutableCopy];
    NSMutableArray *lastestItems = [[appStoreVersion componentsSeparatedByString:@"."] mutableCopy];
  
   
    
    if (![currentVersion isEqualToString:appStoreVersion]) { //比较是否相等
        NSLog(@"有新版本，请更新到最新版本！！！");
        return YES;
    } else {
        NSLog(@"已是最新版本！！！");
        return NO;
    }
}


/// 判断是否最新版本号（大于或等于为最新）
- (BOOL)isLastestVersion:(NSString *)currentVersion compare:(NSString *)lastestVersion {
    if (currentVersion && lastestVersion) {
        // 拆分成数组
        NSMutableArray *currentItems = [[currentVersion componentsSeparatedByString:@"."] mutableCopy];
        NSMutableArray *lastestItems = [[lastestVersion componentsSeparatedByString:@"."] mutableCopy];
        // 如果数量不一样补0
        NSInteger currentCount = currentItems.count;
        NSInteger lastestCount = lastestItems.count;
        if (currentCount != lastestCount) {
            NSInteger count = labs(currentCount - lastestCount); // 取绝对值
            for (int i = 0; i < count; ++i) {
                if (currentCount > lastestCount) {
                    [lastestItems addObject:@"0"];
                } else {
                    [currentItems addObject:@"0"];
                }
            }
        }
        // 依次比较
        BOOL isLastest = YES;
        for (int i = 0; i < currentItems.count; ++i) {
            NSString *currentItem = currentItems[i];
            NSString *lastestItem = lastestItems[i];
            
            if (currentItem.integerValue != lastestItem.integerValue) {
                isLastest = currentItem.integerValue > lastestItem.integerValue;
                break;
            }
        }
        return isLastest;
    }
    return NO;
}





/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
