//
//  NetWorkManager.m
//  ShanYanSDK_Demo
//
//  Created by wanglijun on 2018/10/30.
//  Copyright © 2018 wanglijun. All rights reserved.
//

#import "NetWorkManager.h"
#import <AFNetworking.h>

#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import <CoreTelephony/CTCarrier.h>

@implementation NetWorkManager
+(void)POST_url:(NSString *)urlString withParameter:(NSDictionary *)parameter complete:(CompleteBlock)complete{
    
//AFN:
//    [[AFHTTPSessionManager manager] POST:urlString parameters:parameter progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
//        if (complete) {
//            complete(responseObject,nil);
//        }
//    } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
//        if (complete) {
//            complete(nil,error);
//        }
//    }];
    
    
//原生NSURLSession:
    NSURL *nsurl = [NSURL URLWithString:urlString];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:nsurl];
    request.HTTPMethod = @"POST";
    //URLEncode
    NSString *charactersToEscape = @"#[]@!$'()*+,;\"<>%{}|^~`";
    NSCharacterSet *allowedCharacters = [[NSCharacterSet characterSetWithCharactersInString:charactersToEscape] invertedSet];
    NSMutableString *formDataString = [NSMutableString new];
    [parameter enumerateKeysAndObjectsUsingBlock:^(id  _Nonnull key, id  _Nonnull obj, BOOL * _Nonnull stop) {
        NSString * objString = [NSString stringWithFormat:@"%@",obj];
        [formDataString appendString:[NSString stringWithFormat:@"%@=%@&", key, [objString stringByAddingPercentEncodingWithAllowedCharacters:allowedCharacters]]];
    }];
    request.HTTPBody = [formDataString dataUsingEncoding:NSUTF8StringEncoding];
    
    NSURLSessionConfiguration * config = [NSURLSessionConfiguration defaultSessionConfiguration];
    config.timeoutIntervalForRequest = 10;
    
    NSURLSession *session = [NSURLSession sessionWithConfiguration:config];
    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        if (error) {
            if (complete) {
                complete(nil,error);
            }
        } else {
            if (complete) {
                NSDictionary *dic = nil;
                if (data) {
                        dic = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
                }
                complete(dic,nil);
            }
        }
    }];
    [dataTask resume];

}

+(BOOL)findLocalTelecom{
    //test
//    return NO;
    
    //获取本机运营商名称
    CTTelephonyNetworkInfo *info = [[CTTelephonyNetworkInfo alloc] init];
    CTCarrier *carrier = [info subscriberCellularProvider];
    if (!carrier.isoCountryCode) {
        return NO;
    }
    NSString *mobile = [carrier carrierName];
    if ([mobile isEqualToString:@"中国联通"]) {
    }else if ([mobile isEqualToString:@"中国电信"]) {
    }else if ([mobile isEqualToString:@"中国移动"]) {
    } else {
        return NO;
    }
    return YES;
}

+(void)writeLogWithString:(NSString *)logString{
    NSFileManager *file_manager = [NSFileManager defaultManager];
    BOOL isExit = [file_manager fileExistsAtPath:CL_SHANYANSDK_LOG_SAVEPATH];
    if (!isExit) {
        [file_manager createFileAtPath:CL_SHANYANSDK_LOG_SAVEPATH contents:nil attributes:nil];
    }
    NSFileHandle *outFile = [NSFileHandle fileHandleForWritingAtPath:CL_SHANYANSDK_LOG_SAVEPATH];
    [outFile seekToEndOfFile];
    [outFile writeData:[logString dataUsingEncoding:NSUTF8StringEncoding]];
    [outFile closeFile];
}
+(void)writeLogWithParamr:(NSDictionary *)paramr{
    NSFileManager *file_manager = [NSFileManager defaultManager];
    BOOL isExit = [file_manager fileExistsAtPath:CL_SHANYANSDK_LOG_FULL_SAVEPATH];
    if (!isExit) {
        [file_manager createFileAtPath:CL_SHANYANSDK_LOG_FULL_SAVEPATH contents:nil attributes:nil];
    }
    NSFileHandle *outFile = [NSFileHandle fileHandleForWritingAtPath:CL_SHANYANSDK_LOG_FULL_SAVEPATH];
    [outFile seekToEndOfFile];
    
     NSString * logString = [NSString stringWithFormat:@"【API:%@】【startTime:%@】【endTime:%@】【coust:%@】【stutas:%@】【timestamp:%@】【randoms:%@】【tradeNo:%@】  \n",paramr[@"API"],paramr[@"startTime"],paramr[@"endTime"],paramr[@"coust"],paramr[@"stutas"],paramr[@"timestamp"],paramr[@"randoms"],paramr[@"tradeNo"]];
    
    [outFile writeData:[logString dataUsingEncoding:NSUTF8StringEncoding]];
    [outFile closeFile];
}


@end
