//
//  HomeSectionHeaderView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/16.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "HomeSectionHeaderView.h"
#import "UIColor+Hex.h"
#import "Constants.h"


@interface HomeSectionHeaderView ()

@property (nonatomic, strong)UIView *lineView;



@end
@implementation HomeSectionHeaderView
#pragma mark - life cycle
- (instancetype)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithReuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.lb_title];
        [self addSubview:self.lineView];
        self.contentView.backgroundColor = [UIColor whiteColor];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.left.offset(20 * WIDTHRADIU);
    }];
    
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(10 * WIDTHRADIU);
        make.right.offset(-10 * WIDTHRADIU);
        make.bottom.offset(0);
        make.height.offset(0.5);
    }];
}
#pragma mark - getters and setters
- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_title.font = [UIFont boldSystemFontOfSize:20* WIDTHRADIU];
    }
    return _lb_title;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc]init];
        _lineView.backgroundColor = [UIColor colorWithHex:0x8c8c8c];
    }
    return _lineView;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
