//
//  SocialSecurityApproveSuccessVC.m
//  Open
//
//  Created by 雷俊博 on 2019/9/2.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SocialSecurityApproveSuccessVC.h"

#import "Constants.h"

#import "UIColor+Hex.h"

#import <Masonry.h>

@interface SocialSecurityApproveSuccessVC ()

@property (nonatomic, strong)UIScrollView *scrollview;

@property (nonatomic, strong)UIView *backView;

@property (nonatomic, strong)UIImageView *img_back;

@property (nonatomic, strong)UILabel *lb_department;




@property (nonatomic, strong)UIView *whiteView;

@property (nonatomic, strong)UIImageView *img_photo;

@property (nonatomic, strong)UIImageView *img_date;
@property (nonatomic, strong)UILabel *lb_date;

@property (nonatomic, strong)UIImageView *img_address;
@property (nonatomic, strong)UILabel *lb_address;



@property (nonatomic, strong)UIImageView *img_success;

@property (nonatomic, strong)UILabel *lb_success;

@property (nonatomic, strong)UIButton *btn_approve;

@property (nonatomic, strong)UIButton *btn_back;

@end

@implementation SocialSecurityApproveSuccessVC
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.scrollview];
    
    self.navigationItem.hidesBackButton = YES;
    
    NSString *str = [NSString stringWithFormat:@"%@%@\n%@人力资源和社会保障局",MHSafeStrings(self.model.provinceName),MHSafeStrings(self.model.cityName),MHSafeStrings(self.model.countryName)];
    NSMutableAttributedString *attributedStr = [[NSMutableAttributedString alloc] initWithString:str];
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle.lineSpacing = 8.0 * WIDTHRADIU; // 设置行间距
    paragraphStyle.alignment = NSTextAlignmentCenter; //设置两端对齐显示
    [attributedStr addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, attributedStr.length)];
    self.lb_department.attributedText = attributedStr;
    
    
    self.lb_date.text = MHSafeStrings(self.model.vafiryTime);
    self.lb_address.text = MHSafeStrings(self.model.verifyAdress);
    
    if (self.model.verifyPhoto) {
        self.img_photo.image = [UIImage imageWithData:[[NSData alloc] initWithBase64EncodedString:self.model.verifyPhoto options:NSDataBase64DecodingIgnoreUnknownCharacters]];
    }
   
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.translucent = NO;
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0x1986d4];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0x1986d4];
        [self.navigationController.navigationBar setBackgroundImage:[UIImage  imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
    
    //禁止手势返回
    id traget = self.navigationController.interactivePopGestureRecognizer.delegate;
    UIPanGestureRecognizer * pan = [[UIPanGestureRecognizer alloc]initWithTarget:traget action:nil];
    [self.view addGestureRecognizer:pan];
    
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    [self.lb_department mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(20 * WIDTHRADIU);
        make.centerX.equalTo(self.img_back);
    }];
    
    
    [self.img_photo mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        
        make.width.equalTo(self.whiteView.mas_width).multipliedBy(0.5);
        make.height.offset(190 * WIDTHRADIU);
        make.centerX.equalTo(self.whiteView);
    }];
    
    [self.img_date mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(21 * WIDTHRADIU);
        make.top.equalTo(self.img_photo.mas_bottom).offset(24 * WIDTHRADIU);
    }];
    
    [self.lb_date mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.img_date);
        make.left.equalTo(self.img_date.mas_right).offset(5 * WIDTHRADIU);
    }];
    
    [self.img_address mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(21 * WIDTHRADIU);
        make.top.equalTo(self.img_date.mas_bottom).offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_address mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.img_address);
        make.left.equalTo(self.img_date.mas_right).offset(5 * WIDTHRADIU);
    }];
    
    
    
    
    UIImage *image = [UIImage imageNamed:@"认证成功-对勾-"];
    
    [self.img_success mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(CGRectGetMaxY(self.whiteView.frame) - image.size.height/2);
        make.centerX.equalTo(self.backView);
    }];
    
    [self.lb_success mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.img_success.mas_bottom).offset(20 * WIDTHRADIU);
        make.centerX.equalTo(self.img_success);
    }];
    
    [self.btn_approve mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_success.mas_bottom).offset(30 * WIDTHRADIU);
        make.left.equalTo(self.whiteView);
        make.width.offset((ScreenWidth - 30 * WIDTHRADIU - 45 * WIDTHRADIU)/2);
        make.height.offset(45 * WIDTHRADIU);
    }];
    [self.btn_back mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_success.mas_bottom).offset(30 * WIDTHRADIU);
        make.right.equalTo(self.whiteView);
        make.width.offset((ScreenWidth - 30 * WIDTHRADIU - 45 * WIDTHRADIU)/2);
        make.height.offset(45 * WIDTHRADIU);
    }];
    
}


#pragma mark - event response
- (void)btnClick:(UIButton *)sender
{
    if (sender == self.btn_approve) {
        [self.navigationController popViewControllerAnimated:YES];
    }else if (sender == self.btn_back){
        
        WeakSelf
        UIAlertController * alertVC = [UIAlertController alertControllerWithTitle:@"确认返回首页?" message:nil preferredStyle:UIAlertControllerStyleAlert];
        [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
            NSLog(@"点击取消");
            
        }]];
        
        
        
        [alertVC addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            NSLog(@"点击确认");
            
            [weakSelf.navigationController popToRootViewControllerAnimated:YES];
            
        }]];
        
        [self presentViewController:alertVC animated:YES completion:nil];
    }
}




#pragma mark - getters and setters
- (UIScrollView *)scrollview
{
    if (!_scrollview) {
        _scrollview = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight - cl_kNavigationBarHeight)];
        _scrollview.backgroundColor = [UIColor whiteColor];
        _scrollview.contentSize = CGSizeMake(ScreenWidth, ScreenHeight);
        
        
        _scrollview.showsHorizontalScrollIndicator = NO;
        _scrollview.showsVerticalScrollIndicator = NO;
        
        [_scrollview addSubview:self.backView];
    }
    return _scrollview;
}

- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight * 1)];
        _backView.backgroundColor = [UIColor whiteColor];
        
        [_backView addSubview:self.img_back];
        [_backView addSubview:self.whiteView];
        [_backView addSubview:self.img_success];
        [_backView addSubview:self.lb_success];
        [_backView addSubview:self.btn_approve];
        [_backView addSubview:self.btn_back];
    }
    return _backView;
}

- (UIImageView *)img_back
{
    if (!_img_back) {
        UIImage *image = [UIImage imageNamed:@"img_wave_backview"];
        CGFloat imageWidth = image.size.width;
        CGFloat imageHeight = image.size.height;
        CGFloat imageScale = imageHeight/imageWidth;
        
        _img_back = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, SCREEN_WIDTH *imageScale)];
        _img_back.image = image;
        
        [_img_back addSubview:self.lb_department];
    }
    return _img_back;
}

- (UILabel *)lb_department
{
    if (!_lb_department) {
        _lb_department = [[UILabel alloc]init];
        _lb_department.textAlignment = NSTextAlignmentCenter;
        _lb_department.textColor = [UIColor whiteColor];
        _lb_department.font = [UIFont boldSystemFontOfSize:22 * WIDTHRADIU];
        _lb_department.numberOfLines = 0;
        [_lb_department sizeToFit];
    }
    return _lb_department;
}

- (UIView *)whiteView
{
    if (!_whiteView) {
        _whiteView = [[UIView alloc]initWithFrame:CGRectMake(15 * WIDTHRADIU, CGRectGetMaxY(self.img_back.frame) - 40 * WIDTHRADIU , ScreenWidth - 30 * WIDTHRADIU, 300 * WIDTHRADIU)];
        _whiteView.backgroundColor = [UIColor whiteColor];
        _whiteView.layer.cornerRadius = 8 * WIDTHRADIU;
        
        _whiteView.layer.shadowColor = [UIColor colorWithHex:0x797979].CGColor;
        // 阴影偏移，默认(0, -3)
        _whiteView.layer.shadowOffset = CGSizeMake(0,0);
        // 阴影透明度，默认0
        _whiteView.layer.shadowOpacity = 0.5;
        // 阴影半径，默认3
        _whiteView.layer.shadowRadius = 5 * WIDTHRADIU;
        
        [_whiteView addSubview:self.img_photo];
        [_whiteView addSubview:self.img_date];
        [_whiteView addSubview:self.lb_date];
        [_whiteView addSubview:self.img_address];
        [_whiteView addSubview:self.lb_address];
        
    }
    return _whiteView;
}

- (UIImageView *)img_photo
{
    if (!_img_photo) {
        _img_photo = [[UIImageView alloc]init];
        _img_photo.backgroundColor = [UIColor redColor];
    }
    return _img_photo;
}

- (UIImageView *)img_date
{
    if (!_img_date) {
        _img_date = [[UIImageView alloc]init];
        _img_date.image = [UIImage imageNamed:@"认证成功-时间"];
    }
    return _img_date;
}

- (UILabel *)lb_date
{
    if (!_lb_date) {
        _lb_date = [[UILabel alloc]init];
        _lb_date.textColor = [UIColor colorWithHex:0x999999];
        _lb_date.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_date;
}

- (UIImageView *)img_address
{
    if (!_img_address) {
        _img_address = [[UIImageView alloc]init];
        _img_address.image = [UIImage imageNamed:@"认证成功-地址"];
    }
    return _img_address;
}

- (UILabel *)lb_address
{
    if (!_lb_address) {
        _lb_address = [[UILabel alloc]init];
        _lb_address.textColor = [UIColor colorWithHex:0x999999];
        _lb_address.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_address;
}


- (UIImageView *)img_success
{
    if (!_img_success) {
        _img_success = [[UIImageView alloc]init];
        _img_success.image = [UIImage imageNamed:@"认证成功-对勾-"];
    }
    return _img_success;
}


- (UILabel *)lb_success
{
    if (!_lb_success) {
        _lb_success = [[UILabel alloc]init];
        _lb_success.textColor = [UIColor colorWithHex:0x1986d4];
        _lb_success.font = [UIFont boldSystemFontOfSize:20 * WIDTHRADIU];
        _lb_success.textAlignment = NSTextAlignmentCenter;
        _lb_success.text = @"恭喜您社保认证成功";
    }
    return _lb_success;
}

- (UIButton *)btn_approve
{
    if (!_btn_approve) {
        _btn_approve = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_approve setTitle:@"继续认证" forState:UIControlStateNormal];
        [_btn_approve setBackgroundColor:[UIColor colorWithHex:0x1a480]];
        [_btn_approve setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _btn_approve.titleLabel.font = [UIFont systemFontOfSize:17 * WIDTHRADIU];
        _btn_approve.layer.cornerRadius = 5 * WIDTHRADIU;
        
        [_btn_approve addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_approve;
}

- (UIButton *)btn_back
{
    if (!_btn_back) {
        _btn_back = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_back setTitle:@"返回首页" forState:UIControlStateNormal];
        [_btn_back setBackgroundColor:[UIColor colorWithHex:0x1a480]];
        [_btn_back setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _btn_back.titleLabel.font = [UIFont systemFontOfSize:17 * WIDTHRADIU];
        _btn_back.layer.cornerRadius = 5 * WIDTHRADIU;
        [_btn_back addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_back;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
