//
//  OnFootAlertView.m
//  Open
//
//  Created by 雷俊博 on 2019/9/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "OnFootAlertView.h"
#import <Masonry.h>

#import "UIColor+Hex.h"
#import "UIButton+CQBlockSupport.h"
#import "Constants.h"

@implementation OnFootAlertView


/** 带block回调的弹窗 */
+ (void)alertWithButtonClickedBlock:(void (^)(void))buttonClickedBlock
{
    //大背景
    UIView *bgView = [[UIView alloc]init];
    [[[[UIApplication sharedApplication] delegate] window] addSubview:bgView];
    bgView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.7];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
       make.edges.mas_equalTo(UIEdgeInsetsMake(0, 0, 0, 0));
    }];
    
    
    
    
    UIView *backView  = [[UIView alloc]init];
    backView.backgroundColor = [UIColor clearColor];
    [bgView addSubview:backView];
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(bgView);
        make.size.mas_equalTo(CGSizeMake(272, 245));
    }];
    
    
    // 背景图片
    UIImageView *bgImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"exercise_coinsAlertView"]];
    [backView addSubview:bgImageView];
    [bgImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(bgView);
        make.size.mas_equalTo(CGSizeMake(272, 245));
    }];
    
    
    UILabel *lb_number  = [[UILabel alloc]init];
    lb_number.text = @"+100";
    lb_number.textAlignment = NSTextAlignmentCenter;
    lb_number.textColor = [UIColor colorWithHex:0xfff1d1];
    lb_number.font = [UIFont systemFontOfSize:43];
    [bgImageView addSubview:lb_number];
    [lb_number mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(68);
        make.centerX.equalTo(bgImageView);
        make.height.offset(35);
    }];
    
    UILabel *lb_message  = [[UILabel alloc]init];
    lb_message.text = @"恭喜！您已完成今日健步走";
    lb_message.textAlignment = NSTextAlignmentCenter;
    lb_message.textColor = [UIColor colorWithHex:0xfff1d1];
    lb_message.font = [UIFont systemFontOfSize:15];
    [bgImageView addSubview:lb_message];
    [lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(lb_number.mas_bottom).offset(25);
        make.centerX.equalTo(bgImageView);
        make.height.offset(15);
    }];
    
    
    UIButton *confirmBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [confirmBtn setTitle:@"确定" forState:UIControlStateNormal];
    confirmBtn.backgroundColor = [UIColor clearColor];
    [confirmBtn setTitleColor:[UIColor  colorWithHex:0xfff1d1] forState:UIControlStateNormal];
    confirmBtn.titleLabel.font = [UIFont systemFontOfSize:15];
    confirmBtn.layer.cornerRadius = 17.5;
    confirmBtn.layer.borderColor = [UIColor colorWithHex:0xfff1d1].CGColor;
    confirmBtn.layer.borderWidth = 1.0;
    [confirmBtn  cq_addAction:^(UIButton *button) {
        [bgView removeFromSuperview];
    } forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:confirmBtn];
    [confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(13 + 15);
        make.bottom.offset(-15);
        make.size.mas_equalTo(CGSizeMake(101, 35));
    }];
    
    UIButton *OtherBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [OtherBtn setTitle:@"去抽奖" forState:UIControlStateNormal];
    OtherBtn.backgroundColor = [UIColor colorWithHex:0xfff1d1];
    [OtherBtn setTitleColor:[UIColor  colorWithHex:0xc95215] forState:UIControlStateNormal];
    OtherBtn.titleLabel.font = [UIFont systemFontOfSize:15];
    OtherBtn.layer.cornerRadius = 17.5;
    [OtherBtn cq_addAction:^(UIButton *button) {
        buttonClickedBlock();
        [bgView removeFromSuperview];
    } forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:OtherBtn];
    [OtherBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.offset(-13 - 15);
        make.bottom.offset(-15);
        make.size.mas_equalTo(CGSizeMake(101, 35));
    }];
    
    
    
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
