//
//  FourthlyViewController.m
//  Open
//
//  Created by 看看智能 on 2018/1/10.
//  Copyright © 2018年 黄江涛 . All rights reserved.
//

#import "FourthlyViewController.h"

@interface FourthlyViewController ()<UITextFieldDelegate,UIScrollViewDelegate>
{

    //单选和多选
 __block  int   unemployeeReason_;
 __block   int unemployeeTime_;
 __block   int  originCompany_;

    
    
}
@end

@implementation FourthlyViewController

#pragma mark - 初始化
//单选初始化
-(addressGatherModel *)addressModel
{
    if(!_addressModel){
        _addressModel =[[addressGatherModel alloc]initWithViewController:self];
    }
    return _addressModel;
    
}
-(NSMutableArray *)dataArr
{
    if (!_dataArr) {
        _dataArr =[NSMutableArray array];
        NSArray *result = [CWSqliteModelTool queryAllModels:[PersonJob class]];
        if (result.count > 0) {
            _dataArr = [NSMutableArray arrayWithArray:result];
        }
        
    }
    return _dataArr;
}

+ (FourthlyViewController *)sharedInstance{
    static FourthlyViewController *p = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
        p=[sb instantiateViewControllerWithIdentifier:@"FourthlyViewController"];
    });
    return p;
}
#pragma mark - View
- (void)viewDidLoad {
    [super viewDidLoad];

    //键盘弹起
    [self.view openKeyboardOffsetView];
    self.view.keyboardGap =20;
    //设置高度
    self.employeeScroll.bounces = NO;
    //设置所有为空
    [self makeAllZERO];
    self.title =@"失业信息采集";
    //设置空白和代理
    //点击事件
    UITapGestureRecognizer *get =[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(asdasd)];
    [self.employeeHeightView addGestureRecognizer:get];
    //失业原因
    unemployeeReason_ = 1;
        //失业时间
     unemployeeTime_ = 1;
    //原工作单位
      originCompany_ = 1;
    self.unemployeeReason.placeholder=@"请选择失业原因";
     self.unemployeeTime.placeholder=@"请选择失业时间";
     self.originCompany.placeholder=@"请输入原工作单位";
     SVProgressHUD.minimumDismissTimeInterval =1.0;

}

- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    // 关闭键盘补偿视图
    [self.view closeKeyboardOffsetView];
}
-(void)makeAllZERO{
    [self allDelegateAndAllZero:_unemployeeReason];
    [self allDelegateAndAllZero:_unemployeeTime];
    [self allDelegateAndAllZero:_originCompany];
}
-(void)allDelegateAndAllZero:(UITextField*)textField{
    textField.text =nil;
    //几口请求
    textField.delegate =self;
      textField.textColor =[UIColor blackColor];
    [self textFieldAddTwoBlackPlaceinTextFiled:textField];
}
- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView
{
    return self.employeeHeightView;
}

- (void)updateViewConstraints {
    [super updateViewConstraints];
    self.scroll_width.constant =self.pageNext.frame.origin.y+self.pageNext.bounds.size.height;
}

#pragma mark - 收起按钮
-(void)asdasd{
    [self.view endEditing:YES];
      [SVProgressHUD dismiss];
}
-(BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self.view endEditing:YES];
    return YES;
}
-(BOOL)textFieldShouldBeginEditing:(UITextField*)textField{

    if (textField ==  self.unemployeeReason ||
        textField ==  self.unemployeeTime
        ){
        [self NotUseButton:textField];
        [textField resignFirstResponder];
        return NO;
    }else{
        return YES;
    }
    
    
}


#pragma mark - 所有不能手动输入的按钮
-(NSString*(^)(NSString*))danxuan:(NSString*)names and:( int)ints andshowString:(UITextField *)textFields
{

    __weak typeof(self) wself = self;
    if (self.dataArr.count >0) {
        for (PersonJob *model in self.dataArr) {
            if ([model.nameJob isEqualToString:names]) {
                return      [self.addressModel onlySelect_2:model.politicalStatus Handle:^(NSString *str1, NSString *str2, NSError *error) {
                 int ing =    (int)[JobUtil chooseEmployeeFamilyRelation:[model.politicalStatus copy] andSelectedString:str1];
                
             
                    
                    if (wself.actionToReturnStirng) {
                          wself.actionToReturnStirng(ing,str1);
                    
                    }
                }];
                
            }
        }
    }
    return  nil;
}
- (void)NotUseButton:(UITextField *)sender
{
 [self.view endEditing:YES];
    
    if (sender == self.unemployeeReason) {
//        //失业原因
//__weak typeof(self) wself = self;
//        self.actionToReturnStirng = ^int(int name, NSString *province) {
//            dispatch_async(dispatch_get_main_queue(), ^{
//                   unemployeeReason_ = name;
//                wself.unemployeeReason.text = province;
//            });
//            return 1;
//        };
//       NSString *str11  =[self danxuan:@"lossjobreason" and:unemployeeReason_ andshowString:self.unemployeeReason](@"123123");
//
        __weak typeof(self) wself = self;
        if (self.dataArr.count >0) {
            for (PersonJob *model in self.dataArr) {
                if ([model.nameJob isEqualToString:@"lossjobreason"]) {
                    [self.addressModel onlySelect:model.politicalStatus  Handle:^(NSString *str1, NSString *str2, NSError *error) {
                          unemployeeReason_ =    (int)[JobUtil chooseEmployeeFamilyRelation:[model.politicalStatus copy] andSelectedString:str1];
                         wself.unemployeeReason.text = str1;
                        
                    }];
                }
            }
        }

    }else if (sender == self.unemployeeTime){
        __weak typeof(self) wself = self;
        [LYLDatePicker showDateDetermineChooseInView:self.view determineChoose:^(NSString *dateString) {
            dispatch_async(dispatch_get_main_queue(), ^{
                wself.unemployeeTime.text = dateString;
            });
        }];
    }
    
}

#pragma mark - logicRun

- (IBAction)pageNext:(id)sender {
    if ([self.unemployeeReason.text isEqualToString:@""]) {
        [SVProgressHUD showErrorWithStatus:@"信息没有填写完整"];
        return ;
        
    }
    if ([self.unemployeeTime.text isEqualToString:@""]) {
        [SVProgressHUD showErrorWithStatus:@"信息没有填写完整"];
        return ;
        
    }
    if ([self.originCompany.text isEqualToString:@""]) {
        [SVProgressHUD showErrorWithStatus:@"信息没有填写完整"];
        return ;
        
    }
    
    JobUtil *jobUtil =[[JobUtil alloc]init];
    [SVProgressHUD show];

    [PersonGatherJobNetManager getUserAdddFourId:1 andunemployeeReason:unemployeeReason_ andunemployeeTime:self.unemployeeTime.text andoriginCompanyl:[jobUtil netStrNull:self.originCompany] completionHandle:^(PersonJob *model, NSError *error) {
        [SVProgressHUD dismiss];
        if (model.state == 0 || model.state == 2002) {
            FirthlyViewController*secondVC =   [FirthlyViewController sharedInstance];
            secondVC.chooseThreeDifferent =@"失业新增";
            if(![self.navigationController.topViewController isKindOfClass:[secondVC class]]) {
                
                [self.navigationController pushViewController:secondVC animated:YES];
            }
        }else{
            codeSelected *code = [codeSelected MustTakeReturn:model.state];
            [code returnCodeMethod];
            return;
        }
 
    }];
  
}

@end
