//
//  PaymentDetailTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/8/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "PaymentDetailTableViewCell.h"

#import "Constants.h"
#import "UIColor+Hex.h"

@interface PaymentDetailTableViewCell ()

@property (nonatomic, strong)UILabel *lb_insuranceName;

@property (nonatomic, strong)UILabel *lb_unit_baseNum;

@property (nonatomic, strong)UILabel *lb_company_num;

@property (nonatomic, strong)UILabel *lb_company_percentage;

@property (nonatomic, strong)UILabel *lb_personal_num;

@property (nonatomic, strong)UILabel *lb_personal_percentage;

@property (nonatomic, strong)UILabel *lb_total_num;

@end

@implementation PaymentDetailTableViewCell
#pragma mark - life cycle
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.lb_insuranceName];
        [self addSubview:self.lb_unit_baseNum];
        [self addSubview:self.lb_company_num];
        [self addSubview:self.lb_company_percentage];
        [self addSubview:self.lb_personal_num];
        [self addSubview:self.lb_personal_percentage];
        [self addSubview:self.lb_total_num];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    CGFloat leftMargin = 17 * WIDTHRADIU;
    CGFloat middleDistance = 5 * WIDTHRADIU;
    CGFloat width = (ScreenWidth - 2 * leftMargin - 4 * middleDistance) / 5;
    
    [self.lb_insuranceName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
        make.width.offset(width);
        make.left.offset(leftMargin);
    }];
    
    [self.lb_unit_baseNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lb_insuranceName);
        make.left.equalTo(self.lb_insuranceName.mas_right).offset(middleDistance);
        make.height.offset(15 * WIDTHRADIU);
        make.width.offset(width);
    }];
    
    [self.lb_company_num mas_makeConstraints:^(MASConstraintMaker *make) {
       make.centerY.equalTo(self.lb_insuranceName);
        make.left.equalTo(self.lb_unit_baseNum.mas_right).offset(middleDistance);
        make.height.offset(15 * WIDTHRADIU);
        make.width.offset(width);
    }];
    
    [self.lb_company_percentage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_company_num);
        make.top.equalTo(self.lb_company_num.mas_bottom).offset(6 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    
    [self.lb_personal_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lb_insuranceName);
        make.left.equalTo(self.lb_company_num.mas_right).offset(middleDistance);
        make.height.offset(15 * WIDTHRADIU);
        make.width.offset(width);
    }];
    
    [self.lb_personal_percentage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_personal_num);
        make.top.equalTo(self.lb_personal_num.mas_bottom).offset(6 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.lb_total_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lb_insuranceName);
        make.left.equalTo(self.lb_personal_num.mas_right).offset(middleDistance);
        make.height.offset(15 * WIDTHRADIU);
        make.width.offset(width);
    }];
    
  
}
#pragma mark - getters and setters
- (UILabel *)lb_insuranceName
{
    if (!_lb_insuranceName) {
        _lb_insuranceName = [[UILabel alloc]init];
        _lb_insuranceName.text = @"养老保险";
        _lb_insuranceName.textColor = [UIColor colorWithHex:0x808080];
        _lb_insuranceName.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_insuranceName;
}

- (UILabel *)lb_unit_baseNum
{
    if (!_lb_unit_baseNum) {
        _lb_unit_baseNum = [[UILabel alloc]init];
        _lb_unit_baseNum.text = @"4927";
        _lb_unit_baseNum.textAlignment = NSTextAlignmentCenter;
        _lb_unit_baseNum.textColor = [UIColor colorWithHex:0x808080];
        _lb_unit_baseNum.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_unit_baseNum;
}

- (UILabel *)lb_company_num
{
    if (!_lb_company_num) {
        _lb_company_num = [[UILabel alloc]init];
        _lb_company_num.text = @"788.32";
        _lb_company_num.textAlignment = NSTextAlignmentCenter;
        _lb_company_num.textColor = [UIColor colorWithHex:0x808080];
        _lb_company_num.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_company_num;
}

- (UILabel *)lb_company_percentage
{
    if (!_lb_company_percentage) {
        _lb_company_percentage = [[UILabel alloc]init];
        _lb_company_percentage.text = @"16%";
        _lb_company_percentage.textAlignment = NSTextAlignmentCenter;
        _lb_company_percentage.textColor = [UIColor colorWithHex:0x1886d3];
        _lb_company_percentage.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
    }
    return _lb_company_percentage;
}


- (UILabel *)lb_personal_num
{
    if (!_lb_personal_num) {
        _lb_personal_num = [[UILabel alloc]init];
        _lb_personal_num.text = @"394.16";
        _lb_personal_num.textAlignment = NSTextAlignmentCenter;
        _lb_personal_num.textColor = [UIColor colorWithHex:0x808080];
        _lb_personal_num.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_personal_num;
}

- (UILabel *)lb_personal_percentage
{
    if (!_lb_personal_percentage) {
        _lb_personal_percentage = [[UILabel alloc]init];
        _lb_personal_percentage.text = @"8%";
         _lb_personal_percentage.textAlignment = NSTextAlignmentCenter;
        _lb_personal_percentage.textColor = [UIColor colorWithHex:0x1886d3];
        _lb_personal_percentage.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
    }
    return _lb_personal_percentage;
}


- (UILabel *)lb_total_num
{
    if (!_lb_total_num) {
        _lb_total_num = [[UILabel alloc]init];
        _lb_total_num.text = @"1182.48";
        _lb_total_num.textAlignment = NSTextAlignmentCenter;
        _lb_total_num.textColor = [UIColor colorWithHex:0x808080];
        _lb_total_num.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_total_num;
}




- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
