//
//  LoginView.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/6/28.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "LoginView.h"
#import "Constants.h"
#import <Masonry.h>

@interface LoginView ()

@property (nonatomic, strong)UIImageView *imageView;

@property (nonatomic, strong)UILabel *titleLab;

@property (nonatomic, strong)UIButton * loginBtn;

@end

@implementation LoginView

#pragma mark - life cycle
- (instancetype)initWithTitle:(NSString *)title imageName:(NSString *)imageName
{
    self = [super init];
    if (self) {
        self.imageView.image = [UIImage imageNamed:imageName];
        self.titleLab.text = title;
        [self addSubview:self.imageView];
        [self addSubview:self.titleLab];
        [self addSubview:self.loginBtn];
        [self setUpUI];
    }
    return self;
}

- (void)setUpUI
{
    
    __weak __typeof__(self) weakSelf = self;
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {

        make.centerX.equalTo(weakSelf.mas_centerX);
        make.top.equalTo(weakSelf.mas_top);
        make.height.mas_equalTo(weakSelf.mas_height).multipliedBy(0.68);
         make.width.mas_equalTo(weakSelf.mas_height).multipliedBy(0.68);
    }];
    
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(weakSelf.mas_bottom);
        make.centerX.equalTo(weakSelf.mas_centerX);
        make.height.mas_equalTo(weakSelf.mas_height).multipliedBy(0.24);
    }];
    
    [self.loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
         make.top.equalTo(weakSelf.mas_top);
        make.left.equalTo(weakSelf.mas_left);
         make.bottom.equalTo(weakSelf.mas_bottom);
        make.right.equalTo(weakSelf.mas_right);
    }];
}


#pragma mark - event response
- (void)btnClick
{
    if ([self.delegate respondsToSelector:@selector(loginBtnClickWith:)]) {
        [self.delegate loginBtnClickWith:self];
    }
}

#pragma mark - getters and setters
- (UIImageView *)imageView
{
    if (!_imageView) {
        _imageView = [[UIImageView alloc]init];
    }
    return _imageView;
}

- (UILabel *)titleLab
{
    if (!_titleLab) {
        _titleLab = [[UILabel alloc]init];
        _titleLab.textColor = RGBCOLOR(204, 204, 204);
        _titleLab.textAlignment = NSTextAlignmentCenter;
        _titleLab.font = [UIFont systemFontOfSize:14*WIDTHRADIU];
    }
    return _titleLab;
}

- (UIButton *)loginBtn
{
    if (!_loginBtn) {
        _loginBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_loginBtn addTarget:self action:@selector(btnClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return _loginBtn;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
