//
//  PasswordLoginViewController.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/6/29.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "PasswordLoginViewController.h"
#import "FFPasswordViewController.h"
#import "Constants.h"
#import "LoginView.h"
#import <Masonry.h>
#import <Tools.h>

@interface PasswordLoginViewController ()<loginBtnDelegate, UITextFieldDelegate>
@property (nonatomic, strong)UILabel *lb_Title;


@property (nonatomic, strong)UITextField *tf_Account;

@property (nonatomic, strong)UIView *accountLine;

@property (nonatomic, strong) UITextField *tf_password;


@property (nonatomic, strong) UIView *passwordLine;

@property (nonatomic, strong) UIButton *btn_forgetPassword;

@property (nonatomic, strong) UIButton *loginBtn;


@property (nonatomic, strong) LoginView *wxLogin;

@property (nonatomic, strong) LoginView *directlyLogin;


@property (nonatomic, strong) LoginView * smsLogin;

@property (nonatomic, strong) UIView *leftLine;

@property (nonatomic, strong) UILabel *middleLab;

@property (nonatomic, strong) UIView *rightLine;
@end

@implementation PasswordLoginViewController

#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.

    
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.view addSubview:self.lb_Title];
    [self.view addSubview:self.tf_Account];
    [self.view addSubview:self.accountLine];
    [self.view addSubview:self.tf_password];
    [self.view addSubview:self.passwordLine];
    [self.view addSubview:self.btn_forgetPassword];
    [self.view addSubview:self.loginBtn];
    
    [self.view addSubview:self.wxLogin];
    [self.view addSubview:self.directlyLogin];
    [self.view addSubview:self.smsLogin];
    
    [self.view addSubview:self.leftLine];
    [self.view addSubview:self.middleLab];
    [self.view addSubview:self.rightLine];
    
    [_tf_Account addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
    [_tf_password addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self setupUI];
}
- (void)dealloc
{
    NSLog(@"PasswordLoginViewController已销毁");
}


#pragma mark - loginBtnDelegate
- (void)loginBtnClickWith:(LoginView *)loginView
{
    
    CTLoginBtnType type  = CTLoginBtnTypeDefault;
    
    
        if (loginView == _wxLogin) {
            NSLog(@"点击微信登录");
            type = CTLoginBtnTypeWX;
        }else if (loginView == _directlyLogin){
            NSLog(@"一键登录");
             type = CTLoginBtnTypeDirectly;
        }else if (loginView == _smsLogin){
            NSLog(@"短信登录");
            type = CTLoginBtnTypeSMS;
        }
    
    if ([self.delegate respondsToSelector:@selector(viewController:type:)]) {
        [self.delegate viewController:self type:type];
    }
}

#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [self.view endEditing:YES];
    return YES;
}

#pragma mark - setupUI
- (void)setupUI
{
    
    //title
    
    CGSize topSize = [self.lb_Title.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:25*WIDTHRADIU],NSFontAttributeName, nil]];
    CGFloat topH = topSize.height;
    
    [self.lb_Title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(100 * HEIGHTRADIU);
        make.left.offset(30 * WIDTHRADIU);
        make.height.offset(topH*WIDTHRADIU);
    }];
    
    [self.tf_Account mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_Title.mas_bottom).offset(15*WIDTHRADIU);
        make.left.equalTo(self.lb_Title.mas_left).offset(3 * WIDTHRADIU);
        make.right.offset(-33 * WIDTHRADIU);
        make.height.offset(44*WIDTHRADIU);
    }];
    [self.accountLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_Account.mas_bottom).offset(1*WIDTHRADIU);
        make.left.equalTo(self.lb_Title.mas_left);
        make.right.offset(-30 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
    [self.tf_password mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.accountLine.mas_bottom).offset(9*WIDTHRADIU);
        make.left.equalTo(self.tf_Account.mas_left);
        make.width.equalTo(self.tf_Account.mas_width);
        make.height.equalTo(self.tf_Account.mas_height);
    }];
   
    [self.passwordLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_password.mas_bottom).offset(1*WIDTHRADIU);
        make.left.equalTo(self.accountLine.mas_left);
        make.right.equalTo(self.accountLine.mas_right);
        make.height.equalTo(self.accountLine);
    }];
    
    [self.btn_forgetPassword mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.passwordLine.mas_bottom).offset(15*WIDTHRADIU);
        make.right.equalTo(self.passwordLine.mas_right);
    }];
    
    [self.loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.btn_forgetPassword.mas_bottom).offset(30*WIDTHRADIU);
        make.left.right.equalTo(self.passwordLine);
        make.height.offset(45*WIDTHRADIU);
    }];
    
    
    [self.directlyLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.view.mas_bottom).offset(-40 * WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(72 * WIDTHRADIU);
        make.width.offset(60 * WIDTHRADIU);
    }];
    
    
    
    [self.wxLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.directlyLogin.mas_centerY);
        make.right.equalTo(self.directlyLogin.mas_left).offset(-44* WIDTHRADIU);
        make.height.equalTo(self.directlyLogin.mas_height);
        make.width.equalTo(self.directlyLogin.mas_width);
    }];
    [self.smsLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.directlyLogin.mas_centerY);
        make.left.equalTo(self.directlyLogin.mas_right).offset(44* WIDTHRADIU);
        make.height.equalTo(self.directlyLogin.mas_height);
        make.width.equalTo(self.directlyLogin.mas_width);
    }];
    
    CGSize middleSize = [self.middleLab.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:17],NSFontAttributeName, nil]];
    CGFloat middleH = middleSize.height;
    [self.middleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self -> _wxLogin.mas_top).offset(-35*WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(middleH);
    }];
    [self.middleLab setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    [self.leftLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self.view.mas_left).offset(25 * WIDTHRADIU);
        make.right.equalTo(self -> _middleLab.mas_left).offset(-16);
        make.height.offset(0.5);
    }];
    [self.rightLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self -> _middleLab.mas_right).offset(16);
        make.right.equalTo(self.view.mas_right).offset(-25 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
    
}


#pragma mark - event response
- (void)resetPasswordClick:(UIButton *)sender
{
    [self.view endEditing:YES];
    
    FFPasswordViewController *ffPasswordVC = [[UIStoryboard storyboardWithName:@"Main" bundle:nil]instantiateViewControllerWithIdentifier:@"FFPasswordViewController"];
    ffPasswordVC.title = @"找回密码";
    [self.navigationController pushViewController:ffPasswordVC animated:YES];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}
- (void)loginClick:(UIButton *)sender
{
    [self.view endEditing:YES];
    NSLog(@"123");
    if (![Tools isMobileNumber:_tf_Account.text]) {
        [SVProgressHUD showErrorWithStatus:@"请输入正确的手机号"];
        return;
    }
    
    [SVProgressHUD show];
    
    AppDelegate *delegate=(AppDelegate*)[[UIApplication sharedApplication]delegate];
    delegate.telephoneLoginStr =_tf_Account.text ;
    delegate.telephoneLoginPassport =_tf_password.text ;
        
        [logNetModel getLogMessage3:nil andTelephone:_tf_Account.text andLoginpassword:_tf_password.text andUid:nil andl:0 andweixinId:nil andPicId:nil  completionHandle:^(lodModel *model, NSError *error) {
            if (error) {
                [SVProgressHUD showErrorWithStatus:@"网络出错"];
                return;
            }
            [SVProgressHUD dismiss];
            if ([model.status isEqualToString:@"0"]) {
                NSLog(@"%@",model.code);
                
                // 判断设备是否支持指纹识别功能
                    [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"startAutoLoginState"];
                
                //设置第一次登入为yes
                [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"firstlog"];
                
                [getPeopleID getLoginType:@"passwordlogin"];
                [getPeopleID getLoginPassword:_tf_Account.text];
                [getPeopleID getLoginPassword:_tf_password.text];
                [getPeopleID getPeopletitle:model.userinfo.cus_name];
                [getPeopleID getPeoplePhoto:model.userinfo.photo];
                [getPeopleID getPeopleID:model.userinfo.ID];
                [getPeopleID getPeopleIphoneNmber:model.userinfo.telphone];
                if (model.userinfo.account_type == 0) {
                    [getPeopleID getpeopleLimitedAuthority:YES];
                }else
                {
                    [getPeopleID getpeopleLimitedAuthority:NO];
                }
                [self.navigationController dismissViewControllerAnimated:YES completion:nil];
                
            }else{
                codeSelected *code = [codeSelected MustTakeReturn:[model.status intValue]];
                [code returnCodeMethod];
                if ([model.status isEqualToString:@"9999"]) {
                    [SVProgressHUD showErrorWithStatus:@"账号或密码错误"];
                }
                
            }
        }];
    
    
}

- (void)textFieldDidChange:(UITextField *)textField{
    
    if (_tf_Account.text.length >= 11 && _tf_password.text.length >= 6) {
        _loginBtn.userInteractionEnabled = YES;
        _loginBtn.backgroundColor = RGBCOLOR(51, 138, 208);
    }else{
        _loginBtn.userInteractionEnabled = NO;
        _loginBtn.backgroundColor = RGBCOLOR(197, 197, 197);
    }
    
    if ([textField isEqual:_tf_Account]) {
        if (textField.text.length >=11) {
            textField.text = [textField.text substringToIndex:11];
        }
    }else if ([textField isEqual:_tf_password]){
        if (textField.text.length >=18) {
            [SVProgressHUD showErrorWithStatus:@"只能输6到18位密码"];
            textField.text = [textField.text substringToIndex:18];
        }
    }
    
}

#pragma mark - getters and setters
- (UILabel *)lb_Title
{
    if (!_lb_Title) {
        _lb_Title = [[UILabel alloc]init];
        _lb_Title.text = @"账号密码登录";
        _lb_Title.textColor = RGBCOLOR(77, 77, 77);
        _lb_Title.textAlignment = NSTextAlignmentLeft;
        _lb_Title.font = [UIFont systemFontOfSize:25*WIDTHRADIU];
    }
    return _lb_Title;
}

- (UITextField *)tf_Account
{
    if (!_tf_Account) {
        _tf_Account = [[UITextField alloc]init];
        _tf_Account.keyboardType = UIKeyboardTypeNumberPad;
        _tf_Account.placeholder = @"请输入账号";
        _tf_Account.borderStyle = UITextBorderStyleNone;
        [_tf_Account setValue:RGBCOLOR(153, 153, 153) forKeyPath:@"_placeholderLabel.textColor"];
        [_tf_Account setValue:[UIFont systemFontOfSize:14.0 * WIDTHRADIU] forKeyPath:@"_placeholderLabel.font"];
        _tf_Account.delegate = self;
        
    }
    return _tf_Account;
}

- (UIView *)accountLine
{
    if (!_accountLine) {
        _accountLine = [[UIView alloc]init];
        _accountLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _accountLine;
}

- (UITextField *)tf_password
{
    if (!_tf_password) {
        _tf_password = [[UITextField alloc]init];
        _tf_password.placeholder = @"请输入密码";
        _tf_password.borderStyle = UITextBorderStyleNone;
        [_tf_password setValue:RGBCOLOR(153, 153, 153) forKeyPath:@"_placeholderLabel.textColor"];
        [_tf_password setValue:[UIFont systemFontOfSize:14.0 * WIDTHRADIU] forKeyPath:@"_placeholderLabel.font"];
        _tf_password.delegate = self;
        
    }
    return _tf_password;
}



- (UIView *)passwordLine
{
    if (!_passwordLine) {
        _passwordLine = [[UIView alloc]init];
        _passwordLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _passwordLine;
}

- (UIButton *)btn_forgetPassword
{
    if (!_btn_forgetPassword) {
        _btn_forgetPassword = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_forgetPassword setTitle:@"找回密码" forState:UIControlStateNormal];
        [_btn_forgetPassword setTitleColor:RGBCOLOR(153, 153, 153) forState:UIControlStateNormal];
        _btn_forgetPassword.titleLabel.font = [UIFont systemFontOfSize:14*WIDTHRADIU];
        [_btn_forgetPassword addTarget:self action:@selector(resetPasswordClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_forgetPassword;
}

- (UIButton *)loginBtn
{
    if (!_loginBtn) {
        _loginBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_loginBtn setTitle:@"登录" forState:UIControlStateNormal];
        [_loginBtn.titleLabel setFont:[UIFont systemFontOfSize:16*WIDTHRADIU]];
        [_loginBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_loginBtn setBackgroundColor:RGBCOLOR(142, 142, 142)];
        _loginBtn.layer.cornerRadius = 5*WIDTHRADIU;
        [_loginBtn addTarget:self action:@selector(loginClick:) forControlEvents:UIControlEventTouchUpInside];
        _loginBtn.userInteractionEnabled = NO;
    }
    return _loginBtn;
}




- (LoginView *)wxLogin
{
    if (!_wxLogin) {
        _wxLogin = [[LoginView alloc]initWithTitle:@"微信登录" imageName:@"login_otherlogin_WeChat_normal-1"];
        _wxLogin.delegate = self;
    }
    return _wxLogin;
}
- (LoginView *)directlyLogin
{
    if (!_directlyLogin) {
        _directlyLogin = [[LoginView alloc]initWithTitle:@"一键登录" imageName:@"login_otherlogin_One-click_normal"];
        _directlyLogin.delegate = self;
    }
    return _directlyLogin;
}


- (LoginView *)smsLogin
{
    if (!_smsLogin) {
        _smsLogin = [[LoginView alloc]initWithTitle:@"短信登录" imageName:@"login_otherlogin_SMS_normal"];
        _smsLogin.delegate = self;
    }
    return _smsLogin;
}

- (UIView *)leftLine
{
    if (!_leftLine) {
        _leftLine = [[UIView alloc]init];
        _leftLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _leftLine;
}

- (UILabel *)middleLab
{
    if (!_middleLab) {
        _middleLab = [[UILabel alloc]init];
        _middleLab.textColor = RGBACOLOR(153, 153, 153, 1.0);
        _middleLab.text = @"其他登录方式";
        _middleLab.textAlignment = NSTextAlignmentCenter;
        _middleLab.font = [UIFont systemFontOfSize:12*WIDTHRADIU];
    }
    return _middleLab;
}

- (UIView *)rightLine
{
    if (!_rightLine) {
        _rightLine = [[UIView alloc]init];
        _rightLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _rightLine;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
