//
//  LoginVC.m
//  Open
//
//  Created by 雷俊博 on 2019/6/30.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "LoginVC.h"
#import "loginProtocol.h"

#import "WXLoginViewController.h"
#import "SMSLoginViewController.h"
#import "PasswordLoginViewController.h"

@interface LoginVC ()<LoginClickDelegate>

@property (nonatomic, strong)WXLoginViewController *wxVC;

@property (nonatomic, strong)SMSLoginViewController *smsVC;

@property (nonatomic, strong)PasswordLoginViewController *passwordVC;

@end

@implementation LoginVC
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.navigationController.navigationBar setBackgroundImage:[[UIImage alloc]init] forBarMetrics:UIBarMetricsDefault];
    
    [self.navigationController.navigationBar setShadowImage:[[UIImage alloc]init]];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithImage:[[UIImage imageNamed:@"back"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal]  style:UIBarButtonItemStylePlain target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    
    [self addChildViewController:self.wxVC];
    [self addChildViewController:self.smsVC];
    [self addChildViewController:self.passwordVC];
    [self fitFrameForChildViewController:self.wxVC];
    [self fitFrameForChildViewController:self.smsVC];
    [self fitFrameForChildViewController:self.passwordVC];
    [self.view addSubview:self.wxVC.view];
    [self.view addSubview:self.smsVC.view];
    [self.view addSubview:self.passwordVC.view];
    [self.view bringSubviewToFront:self.wxVC.view];
    
    //预取号
     [CLShanYanSDKManager preGetPhonenumber:nil];
    
}
- (void)dealloc
{
    NSLog(@"LoginVC已销毁");
}

#pragma mark - LoginClickDelegate
- (void)viewController:(UIViewController *)vc type:(CTLoginBtnType)type
{
    switch (type) {
        case CTLoginBtnTypeWX:
            [self.view bringSubviewToFront:self.wxVC.view];
            break;
        case CTLoginBtnTypeSMS:
            [self.view bringSubviewToFront:self.smsVC.view];
            break;
        case CTLoginBtnTypePassword:
            [self.view bringSubviewToFront:self.passwordVC.view];
            break;
        case CTLoginBtnTypeDirectly:
            
            [self clLogin];
            break;
            
        default:
            break;
    }
}

- (void)clLogin
{
    
    CGFloat screenScale = [UIScreen mainScreen].bounds.size.width/375.0;
    
    CLUIConfigure * baseUIConfigure = [CLUIConfigure new];
    baseUIConfigure.viewController = self;
    baseUIConfigure.manualDismiss = @(YES);

    //NAV
    baseUIConfigure.cl_navigation_backgroundClear = @(YES);
    baseUIConfigure.cl_navigation_backBtnImage = [UIImage imageNamed:@"928返回"];
    
    //LOGO
    baseUIConfigure.clLogoImage = [UIImage imageNamed:@"logo"];
    baseUIConfigure.clLogoWidth = @(100);
    baseUIConfigure.clLogoHeight = @(100);
    baseUIConfigure.clLogoOffsetY = @(100 * screenScale);
    
    //手机号显示控件
    baseUIConfigure.clPhoneNumberColor = UIColor.blackColor;
    baseUIConfigure.clPhoneNumberOffsetY = @(250*screenScale);
    baseUIConfigure.clPhoneNumberWidth = @(200);
    baseUIConfigure.clPhoneNumberHeight = @(20);
    baseUIConfigure.clPhoneNumberFont = [UIFont fontWithName:@"PingFang-SC-Medium" size:20.0];
    
    baseUIConfigure.clLoginBtnText = @"本机号一键登录";
    baseUIConfigure.clLoginBtnBgColor = [UIColor colorWithRed:27/255.0 green:132/255.0 blue:208/255.0 alpha:1.0];
    baseUIConfigure.clLoginBtnTextColor = [UIColor whiteColor];
    baseUIConfigure.clLoginBtnOffsetY = @(290*screenScale);
    baseUIConfigure.clLoginBtnWidth = @(self.view.bounds.size.width * 0.8);
    baseUIConfigure.clLoginBtnHeight =  @(40);
    baseUIConfigure.clLoginBtnCornerRadius = @(20);
    
    // baseUIConfigure.clAppPrivacyName = @"《我测条款名》";
    // baseUIConfigure.clAppPrivacyUrlString = @"https://www.baidu.com";
    // baseUIConfigure.clAppPrivacyColor = UIColor.greenColor;
    
    //CustomAreaView
    __weak typeof(self) weakSelf = self;
    baseUIConfigure.customAreaView = ^(UIView * _Nonnull customAreaView) {
        //customAreaView为导航条以下的全屏 375*667比例系数适配 默认375*667下一键登录button底部y约为 270
        
//        UIButton * button = [[UIButton alloc]init];
//        [button setTitle:@"其他方式登录" forState:(UIControlStateNormal)];
//        button.titleLabel.font = [UIFont systemFontOfSize:14];
//        [button setTitleColor:[UIColor grayColor] forState:(UIControlStateNormal)];
//        [button addTarget:weakSelf action:@selector(otherLoginWayBtnCliced:) forControlEvents:(UIControlEventTouchUpInside)];
//        [customAreaView addSubview:button];
//
//        [button mas_makeConstraints:^(MASConstraintMaker *make) {
//            make.left.right.mas_equalTo(0);
//            make.top.mas_equalTo(340*screenScale);
//            make.height.mas_equalTo(40);
//        }];
    };
    
//    [SVProgressHUD setContainerView:self.view];
//    [SVProgressHUD show];
    [CLShanYanSDKManager quickAuthLoginWithConfigure:baseUIConfigure  timeOut:4 shanyanAuthPageListener:^(CLCompleteResult * _Nonnull completeResult) {
        
    }  complete:^(CLCompleteResult * _Nonnull completeResult) {
        
       // [SVProgressHUD dismiss];
        if (completeResult.error) {
            
            //提示：错误无需提示给用户，可以在用户无感知的状态下直接切换登录方式
            if (completeResult.code == 1011){
                //用户取消登录（点返回）
                //处理建议：如无特殊需求可不做处理，仅作为交互状态回调，此时已经回到当前用户自己的页面
                [SVProgressHUD showInfoWithStatus: @"用户取消免密登录"];
            }else if (completeResult.code == 1008){
                //用户取消登录（点返回）
                //处理建议：如无特殊需求可不做处理，仅作为交互状态回调，此时已经回到当前用户自己的页面
                [SVProgressHUD showInfoWithStatus: @"未开启移动网络"];
            }else if (completeResult.code == 1008){
                //用户取消登录（点返回）
                //处理建议：如无特殊需求可不做处理，仅作为交互状态回调，此时已经回到当前用户自己的页面
                [SVProgressHUD showInfoWithStatus: @"未检测到sim卡"];
            }else{
                //处理建议：其他错误代码表示闪验通道无法继续，可以统一走开发者自己的其他登录方式，也可以对不同的错误单独处理
                //1003    一键登录获取token失败
                //1008    未开启移动网络
                //1009    未检测到sim卡
                //其他     其他错误//
                
                [SVProgressHUD showInfoWithStatus:@"其他错误"];
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    //雷俊博代码,因为是照着之前人写的,没有把快速登录界面设置为单例类,比较麻烦,之后再改
                    
                    
                    // LoginResultController *vc = [LoginResultController new];
                    // vc.error = completeResult.error;
                    // [weakSelf.navigationController pushViewController:vc animated:YES];
                    //  NSLog(@"%@",completeResult.error);
                });
            }
        }else{
            
            
            
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                
                NSLog(@"quickAuthLogin Success:%@",completeResult.data);
                //LoginResultController *vc = [LoginResultController new];
                //vc.completeResultData = completeResult.data;
                //vc.timesStart = startButtonClick;
                //[self getPhonenumber];
                
                [SVProgressHUD show];
                [logNetModel QuickLogin:[completeResult.data objectForKey:@"appId"] andAccessToken:[completeResult.data objectForKey:@"accessToken"] andTelecom:[completeResult.data objectForKey:@"telecom"] andTimeStamp:[completeResult.data objectForKey:@"timestamp"] andRandoms:[completeResult.data objectForKey:@"randoms"] andVersion:[completeResult.data objectForKey:@"version"] andDevice:[completeResult.data objectForKey:@"device"] andSign:[completeResult.data objectForKey:@"sign"] completionHandle:^(logModel_2 *model, NSError *error) {
                    {
                        
                        [SVProgressHUD dismiss];
                        NSLog(@"12345678");
                        NSLog(@"logResultModel%@",model.result);
                        
                        if ([model.code isEqualToString:@"0"]) {
                            NSLog(@"123%@",model.code);
                            //判断账号是否登入时候使用
                            [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"firstlog"];
                            [getPeopleID getLoginType:@"directlylogin"];
                            [getPeopleID getPeopletitle:model.result.cus_name];
                            [getPeopleID getPeoplePhoto:model.result.photo];
                            [getPeopleID getPeopleID:model.result.ID];
                            [getPeopleID getPeopleIphoneNmber:model.result.telphone];
                            AppDelegate *delegate=(AppDelegate*)[[UIApplication sharedApplication]delegate];
                            
                            if ( delegate.isLogin == NO) {
                                [getPeopleID getProvince:model.result.provinceName];
                                
                            }
                            if (model.result.account_type == 0) {
                                
                                [getPeopleID getpeopleLimitedAuthority:YES];
                            }else
                            {
                                [getPeopleID getpeopleLimitedAuthority:NO];
                            }
                            
                            [self.navigationController dismissViewControllerAnimated:NO completion:^{
                                [self dismissViewControllerAnimated:YES completion:nil];
                            }];
                            
                        }else{
                            
                            //雷俊博代码
                            
                            
                            //[SVProgressHUD showErrorWithStatus:@"一键登录失败"];
                            
                            //雷俊博代码
                            
                            codeSelected *code = [codeSelected MustTakeReturn:[model.code intValue]];
                            [code returnCodeMethod];
                            
                        }
                    }
                    
                }];
                if(weakSelf.navigationController){
                    // [weakSelf.navigationController pushViewController:vc animated:YES];
                } else {
                    // [weakSelf presentViewController:vc animated:YES completion:^{
                    
                    // }];
                }
                
                
            });
        }
    }];
        
       
    
}

#pragma mark - event response
- (void)back
{
    [self.view endEditing:YES];
    NSLog(@"返回了");
    
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}


#pragma mark - private methods
- (void)fitFrameForChildViewController:(UIViewController *)chileViewController{
    
    chileViewController.view.frame = self.view.bounds;
    
}


#pragma mark - getters and setters
- (WXLoginViewController *)wxVC
{
    if (!_wxVC) {
        _wxVC = [WXLoginViewController new];
        _wxVC.delegate = self;
    }
    return _wxVC;
}
- (SMSLoginViewController *)smsVC
{
    if (!_smsVC) {
        _smsVC = [SMSLoginViewController new];
        _smsVC.delegate =self;
    }
    return _smsVC;
}
- (PasswordLoginViewController *)passwordVC
{
    if (!_passwordVC) {
        _passwordVC = [PasswordLoginViewController new];
        _passwordVC.delegate = self;
    }
    return _passwordVC;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
