//
//  WXLoginViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/6/30.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "WXLoginViewController.h"
#import "LoginView.h"
#import "Constants.h"
#import "LoginView.h"
#import "UIButton+ImageTitleSpacing.h"

#import "BPViewController.h"

#import <Masonry.h>

@interface WXLoginViewController ()<loginBtnDelegate>



@property (nonatomic, strong) UIImageView * imgView_topIcon;

@property (nonatomic, strong) UILabel *lab_title;

@property (nonatomic, strong) UIButton *btn_WXLogin;

@property (nonatomic, strong) LoginView *directlyLogin;

@property (nonatomic, strong) LoginView *smsLogin;

@property (nonatomic, strong) LoginView * passwordLogin;

@property (nonatomic, strong) UIView *leftLine;

@property (nonatomic, strong) UILabel *middleLab;

@property (nonatomic, strong) UIView *rightLine;

@end

@implementation WXLoginViewController
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
   
    
    [self.view addSubview:self.imgView_topIcon];
    [self.view addSubview:self.lab_title];
    [self.view addSubview:self.btn_WXLogin];
    [self.view addSubview:self.directlyLogin];
    [self.view addSubview:self.smsLogin];
    [self.view addSubview:self.passwordLogin];
    
    [self.view addSubview:self.leftLine];
    [self.view addSubview:self.middleLab];
    [self.view addSubview:self.rightLine];
    
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self setupUI];
}

- (void)dealloc
{
    NSLog(@"WXLoginViewController已销毁");
}


#pragma mark - loginBtnDelegate
- (void)loginBtnClickWith:(LoginView *)loginView
{
    CTLoginBtnType type  = CTLoginBtnTypeDefault;
    if (loginView == self.directlyLogin) {
        NSLog(@"一键登录");
        type = CTLoginBtnTypeDirectly;
    }else if (loginView == self.smsLogin){
        NSLog(@"短信登录");
        type = CTLoginBtnTypeSMS;
        //        SMSViewController *smsVC = [[SMSViewController alloc]init];
        //        [self.navigationController pushViewController:smsVC animated:YES];
    }else if (loginView == self.passwordLogin){
        NSLog(@"密码登录");
        type = CTLoginBtnTypePassword;
        //        PasswordLoginViewController *passwordVC  = [[PasswordLoginViewController alloc]init];
        //        [self.navigationController pushViewController:passwordVC animated:YES];
    }
    if ([self.delegate respondsToSelector:@selector(viewController:type:)]) {
        [self.delegate viewController:self type:type];
    }
}

#pragma mark - event response
//微信的第三方登入
-(void)tapWeChat{
    
    [self getUserInfoForPlatform:UMSocialPlatformType_WechatSession];
}


#pragma mark - private methods
//第三方登入
- (void)getUserInfoForPlatform:(UMSocialPlatformType)platformType
{
    [[UMSocialManager defaultManager] getUserInfoWithPlatform:platformType currentViewController:self completion:^(id result, NSError *error) {
        NSLog(@">>>>>wx>>result:%@, error:%@",result,error);
        
        if (error) {
             [SVProgressHUD showErrorWithStatus:@"微信授权失败!"];
            return;
        }
        
        UMSocialUserInfoResponse *resp = result;
        if(resp.uid ){
            if (!resp.name) {
                resp.name =@"";
            }
            if (!resp.iconurl) {
                resp.iconurl=@"";
            }
            
            [self SenderSecondNetWorking:resp.uid andTelephone:nil andTelephonePassWord:nil andweixinId:resp.name andPicId:resp.iconurl];
        }
        // 第三方登录数据(为空表示平台未提供)
        // 授权数据
        NSLog(@" uid: %@", resp.uid);//uuid
        NSLog(@" openid: %@", resp.openid);
        NSLog(@" accessToken: %@", resp.accessToken);
        NSLog(@" refreshToken: %@", resp.refreshToken);
        NSLog(@" expiration: %@", resp.expiration);
        
        // 用户数据
        NSLog(@" name: %@", resp.name);
        NSLog(@" iconurl: %@", resp.iconurl);
        NSLog(@" gender: %@", resp.gender);
        
        // 第三方平台SDK原始数据
        NSLog(@" originalResponse: %@", resp.originalResponse);
    }];
}

#pragma mark - 网络请求
//曹妈妈
-(void)SenderSecondNetWorking:(NSString *)weixinStr andTelephone:(NSString*)telphone andTelephonePassWord:(NSString*)telephonePwd andweixinId:(NSString*)weixinId andPicId:(NSString *)picId{
    
    [SVProgressHUD shows];
    [logNetModel getLogMessage3:weixinStr andTelephone:telphone andLoginpassword:telephonePwd andUid:nil andl:2 andweixinId:weixinId andPicId:picId  completionHandle:^(lodModel *model, NSError *error) {
        [SVProgressHUD doneShow];
        if (error) {
            [SVProgressHUD showErrorWithStatus:@"网络出错"];
            return;
        }
        //test
        [SVProgressHUD dismiss];
        
        if ([model.status isEqualToString:@"0"]) {
            
             [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"firstlog"];
            
            if (model.userinfo.cus_name)
            {
                
                NSString *cusName = model.userinfo.cus_name;
                [getPeopleID getPeopletitle:cusName];
            } else {
                [getPeopleID getPeopletitle:weixinId];
            }
            
            if (!picId)  [getPeopleID getPeoplePhoto:model.userinfo.photo]; else [getPeopleID getPeoplePhoto:picId];
            [getPeopleID getLoginType:@"wxlogin"];
             [getPeopleID getPeoplePhoto:model.userinfo.photo];
            [getPeopleID getPeopleID:model.userinfo.ID];
            [getPeopleID getPeopleIphoneNmber:model.userinfo.telphone];
            if (model.userinfo.account_type == 0) {
                [getPeopleID getpeopleLimitedAuthority:YES];
            }else
            {
                [getPeopleID getpeopleLimitedAuthority:NO];
            }
            [self.navigationController dismissViewControllerAnimated:YES completion:nil];
          
        }else if ([model.status isEqualToString:@"1031"]){
            BPViewController *bpVC = [[BPViewController alloc]init];
            bpVC.UID = weixinStr;
            bpVC.Id = [NSString stringWithFormat:@"%ld",model.userinfo.ID];
            bpVC.wxName = weixinId;
            bpVC.wxPhotoUrl = picId;
            bpVC.title = @"绑定手机号";
            [self.navigationController pushViewController:bpVC animated:YES];
        }
        else{
            //错误码提示
            codeSelected *code = [codeSelected MustTakeReturn:[model.status intValue]];
            [code returnCodeMethod];
        }
    }];

}

- (void)setupUI
{
    //图标
    [self.imgView_topIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view.mas_centerX);
        make.top.offset(104 * HEIGHTRADIU);
        make.width.offset(70*WIDTHRADIU);
        make.height.offset(70*WIDTHRADIU);
    }];
    
    //title
    
    CGSize topSize = [self.lab_title.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:17],NSFontAttributeName, nil]];
    CGFloat topH = topSize.height;
    
    [self.lab_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self -> _imgView_topIcon.mas_bottom).offset(24*WIDTHRADIU);
        make.left.right.offset(0);
        make.height.offset(topH);
    }];
    
    
    //wxBtn
    [self.btn_WXLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self -> _lab_title.mas_bottom).offset(46*WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.width.offset(315 * WIDTHRADIU);
        make.height.offset(45 * WIDTHRADIU);
    }];
    
    
    [self.smsLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.view.mas_bottom).offset(-40 * WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(72 * WIDTHRADIU);
        make.width.offset(60 * WIDTHRADIU);
    }];
    
    
    
    [self.directlyLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.smsLogin.mas_centerY);
        make.right.equalTo(self.smsLogin.mas_left).offset(-44* WIDTHRADIU);
        make.height.equalTo(self.smsLogin.mas_height);
        make.width.equalTo(self.smsLogin.mas_width);
    }];
    [self.passwordLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.smsLogin.mas_centerY);
        make.left.equalTo(self.smsLogin.mas_right).offset(44* WIDTHRADIU);
        make.height.equalTo(self.smsLogin.mas_height);
        make.width.equalTo(self.smsLogin.mas_width);
    }];
    
    CGSize middleSize = [self.middleLab.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:17],NSFontAttributeName, nil]];
    CGFloat middleH = middleSize.height;
    [self.middleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self -> _smsLogin.mas_top).offset(-35*WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(middleH);
    }];
    [self.middleLab setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    [self.leftLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self.view.mas_left).offset(25 * WIDTHRADIU);
        make.right.equalTo(self -> _middleLab.mas_left).offset(-16);
        make.height.offset(0.5);
    }];
    [self.rightLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self -> _middleLab.mas_right).offset(16);
        make.right.equalTo(self.view.mas_right).offset(-25 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
}
#pragma mark - getters and setters
- (UIImageView *)imgView_topIcon
{
    if (!_imgView_topIcon) {
        ;
        UIImage *image = [UIImage imageNamed:@"login_icon"];
        _imgView_topIcon = [[UIImageView alloc]init];
        _imgView_topIcon.image = image;
        
    }
    return _imgView_topIcon;
}

- (UILabel *)lab_title
{
    if (!_lab_title) {
        _lab_title = [[UILabel alloc]init];
        _lab_title.textColor = RGBACOLOR(77, 77, 77, 1.0);
        _lab_title.text = @"看看社保-让发钱更简单";
        _lab_title.textAlignment = NSTextAlignmentCenter;
        _lab_title.font = [UIFont systemFontOfSize:20*WIDTHRADIU];
    }
    return _lab_title;
}

- (UIButton *)btn_WXLogin
{
    if (!_btn_WXLogin) {
        _btn_WXLogin = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_WXLogin setImage:[UIImage imageNamed:@"login_button_WeChat_normal"] forState:UIControlStateNormal];
        [_btn_WXLogin setTitle:@"微信一键登录" forState:UIControlStateNormal];
        [_btn_WXLogin.titleLabel setFont:[UIFont systemFontOfSize:16*WIDTHRADIU]];
        [_btn_WXLogin setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_btn_WXLogin setBackgroundColor:RGBCOLOR(22, 124, 205)];
        _btn_WXLogin.layer.cornerRadius = 5*WIDTHRADIU;
        [_btn_WXLogin layoutButtonWithEdgeInsetsStyle:GLButtonEdgeInsetsStyleLeft imageTitleSpace:8*WIDTHRADIU];
        [_btn_WXLogin addTarget:self action:@selector(tapWeChat) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_WXLogin;
}

- (LoginView *)directlyLogin
{
    if (!_directlyLogin) {
        _directlyLogin = [[LoginView alloc]initWithTitle:@"一键登录" imageName:@"login_otherlogin_One-click_normal"];
        _directlyLogin.delegate = self;
    }
    return _directlyLogin;
}

- (LoginView *)smsLogin
{
    if (!_smsLogin) {
        _smsLogin = [[LoginView alloc]initWithTitle:@"短信登录" imageName:@"login_otherlogin_SMS_normal"];
        _smsLogin.delegate = self;
    }
    return _smsLogin;
}

- (LoginView *)passwordLogin
{
    if (!_passwordLogin) {
        _passwordLogin = [[LoginView alloc]initWithTitle:@"密码登录" imageName:@"login_otherlogin_password_normal"];
        _passwordLogin.delegate = self;
    }
    return _passwordLogin;
}

- (UIView *)leftLine
{
    if (!_leftLine) {
        _leftLine = [[UIView alloc]init];
        _leftLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _leftLine;
}

- (UILabel *)middleLab
{
    if (!_middleLab) {
        _middleLab = [[UILabel alloc]init];
        _middleLab.textColor = RGBACOLOR(153, 153, 153, 1.0);
        _middleLab.text = @"其他登录方式";
        _middleLab.textAlignment = NSTextAlignmentCenter;
        _middleLab.font = [UIFont systemFontOfSize:12*WIDTHRADIU];
    }
    return _middleLab;
}

- (UIView *)rightLine
{
    if (!_rightLine) {
        _rightLine = [[UIView alloc]init];
        _rightLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _rightLine;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
