//
//  SMSLoginViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/6/30.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SMSLoginViewController.h"
#import "Constants.h"
#import <Masonry.h>
#import "Tools.h"

#import "LoginView.h"
#define TIMECOUNT 60
@interface SMSLoginViewController ()<loginBtnDelegate,UITextFieldDelegate>

@property (nonatomic, strong)UILabel *lb_Title;

@property (nonatomic, strong)UILabel *lb_SubTitle;

@property (nonatomic, strong)UITextField *tf_Phone;

@property (nonatomic, strong)UIView *phoneLine;

@property (nonatomic, strong) UITextField *tf_VerificationCode;

@property (nonatomic, strong)UIView *dividerLine;

@property (nonatomic, strong) UIButton *btn_VerificationCode;

@property (nonatomic, strong) UIView *codeLine;

@property (nonatomic, strong) UIButton *loginBtn;


@property (nonatomic, strong) LoginView *wxLogin;

@property (nonatomic, strong) LoginView *directlyLogin;


@property (nonatomic, strong) LoginView * passwordLogin;

@property (nonatomic, strong) UIView *leftLine;

@property (nonatomic, strong) UILabel *middleLab;

@property (nonatomic, strong) UIView *rightLine;

@end

@implementation SMSLoginViewController
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.view addSubview:self.lb_Title];
    [self.view addSubview:self.lb_SubTitle];
    [self.view addSubview:self.tf_Phone];
    [self.view addSubview:self.phoneLine];
    [self.view addSubview:self.tf_VerificationCode];
    [self.view addSubview:self.dividerLine];
    [self.view addSubview:self.btn_VerificationCode];
    [self.view addSubview:self.codeLine];
    [self.view addSubview:self.loginBtn];
    
    [self.view addSubview:self.wxLogin];
    [self.view addSubview:self.directlyLogin];
    [self.view addSubview:self.passwordLogin];
    
    [self.view addSubview:self.leftLine];
    [self.view addSubview:self.middleLab];
    [self.view addSubview:self.rightLine];
    
    [_tf_Phone addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
    [_tf_VerificationCode addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self setupUI];
}
- (void)dealloc
{
    NSLog(@"SMSLoginViewController已销毁");
}

#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [textField resignFirstResponder];
    return YES;
}



#pragma mark - loginBtnDelegate
- (void)loginBtnClickWith:(LoginView *)loginView
{
    CTLoginBtnType type  = CTLoginBtnTypeDefault;
    if (loginView == _wxLogin) {
        NSLog(@"点击微信登录");
        type = CTLoginBtnTypeWX;
    }else if (loginView == _directlyLogin){
        NSLog(@"一键登录");
        type = CTLoginBtnTypeDirectly;
    }else if (loginView == _passwordLogin){
        NSLog(@"密码登录");
        type = CTLoginBtnTypePassword;
    }
    
    
    if ([self.delegate respondsToSelector:@selector(viewController:type:)]) {
        [self.delegate viewController:self type:type];
    }
    
}


#pragma mark - event response
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}

- (void)textFieldDidChange:(UITextField *)textField{
    
    if (_tf_Phone.text.length >= 11 && _tf_VerificationCode.text.length >= 4) {
        _loginBtn.userInteractionEnabled = YES;
        _loginBtn.backgroundColor = RGBCOLOR(51, 138, 208);
    }else{
        _loginBtn.userInteractionEnabled = NO;
        _loginBtn.backgroundColor = RGBCOLOR(197, 197, 197);
    }
    
    if ([textField isEqual:_tf_Phone]) {
        if (textField.text.length >=11) {
            textField.text = [textField.text substringToIndex:11];
        }
    }else if ([textField isEqual:_tf_VerificationCode]){
        if (textField.text.length >=4) {
            textField.text = [textField.text substringToIndex:4];
        }
    }
    
}

#pragma mark - setupUI
- (void)setupUI
{
    
    //title
    
    CGSize topSize = [self.lb_Title.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:25*WIDTHRADIU],NSFontAttributeName, nil]];
    CGFloat topH = topSize.height;
    
    [self.lb_Title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(90 * HEIGHTRADIU);
        make.left.offset(30 * WIDTHRADIU);
        make.height.offset(topH*WIDTHRADIU);
    }];
    
    CGSize topSize2 = [self.lb_SubTitle.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:14*WIDTHRADIU],NSFontAttributeName, nil]];
    CGFloat topH2 = topSize2.height;
    [self.lb_SubTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_Title.mas_bottom).offset(14*WIDTHRADIU);
        make.left.equalTo(self.lb_Title.mas_left);
        make.height.offset(topH2*WIDTHRADIU);
    }];
    [self.tf_Phone mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_SubTitle.mas_bottom).offset(17*WIDTHRADIU);
        make.left.equalTo(self.lb_SubTitle.mas_left).offset(3 * WIDTHRADIU);
        make.right.offset(-33 * WIDTHRADIU);
        make.height.offset(44*WIDTHRADIU);
    }];
    [self.phoneLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_Phone.mas_bottom).offset(1*WIDTHRADIU);
        make.left.equalTo(self.lb_SubTitle.mas_left);
        make.right.offset(-30 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
    [self.tf_VerificationCode mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.phoneLine.mas_bottom).offset(9*WIDTHRADIU);
        make.left.equalTo(self.tf_Phone.mas_left);
        make.width.offset(200*WIDTHRADIU);
        make.height.equalTo(self.tf_Phone.mas_height);
    }];
    [self.dividerLine mas_makeConstraints:^(MASConstraintMaker *make) {
        
        make.centerY.equalTo(self.tf_VerificationCode);
        make.left.equalTo(self.tf_VerificationCode.mas_right);
        make.width.offset(0.5);
        make.height.offset(25 *WIDTHRADIU);
    }];
    [self.btn_VerificationCode mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.tf_VerificationCode);
        make.left.equalTo(self.dividerLine.mas_right).offset(9*WIDTHRADIU);
    }];
    [self.codeLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tf_VerificationCode.mas_bottom).offset(1*WIDTHRADIU);
        make.left.equalTo(self.phoneLine.mas_left);
        make.right.equalTo(self.phoneLine.mas_right);
        make.height.equalTo(self.phoneLine);
    }];
    
    [self.loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.codeLine.mas_bottom).offset(50*WIDTHRADIU);
        make.left.right.equalTo(self.codeLine);
        make.height.offset(45*WIDTHRADIU);
    }];
    
    
    [self.directlyLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.view.mas_bottom).offset(-40 * WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(72 * WIDTHRADIU);
        make.width.offset(60 * WIDTHRADIU);
    }];
    
    
    
    [self.wxLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.directlyLogin.mas_centerY);
        make.right.equalTo(self.directlyLogin.mas_left).offset(-44* WIDTHRADIU);
        make.height.equalTo(self.directlyLogin.mas_height);
        make.width.equalTo(self.directlyLogin.mas_width);
    }];
    [self.passwordLogin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.directlyLogin.mas_centerY);
        make.left.equalTo(self.directlyLogin.mas_right).offset(44* WIDTHRADIU);
        make.height.equalTo(self.directlyLogin.mas_height);
        make.width.equalTo(self.directlyLogin.mas_width);
    }];
    
    CGSize middleSize = [self.middleLab.text sizeWithAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:17],NSFontAttributeName, nil]];
    CGFloat middleH = middleSize.height;
    [self.middleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self -> _wxLogin.mas_top).offset(-35*WIDTHRADIU);
        make.centerX.equalTo(self.view.mas_centerX);
        make.height.offset(middleH);
    }];
    [self.middleLab setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    [self.leftLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self.view.mas_left).offset(25 * WIDTHRADIU);
        make.right.equalTo(self -> _middleLab.mas_left).offset(-16);
        make.height.offset(0.5);
    }];
    [self.rightLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.middleLab.mas_centerY);
        make.left.equalTo(self -> _middleLab.mas_right).offset(16);
        make.right.equalTo(self.view.mas_right).offset(-25 * WIDTHRADIU);
        make.height.offset(0.5);
    }];
    
}


#pragma mark - event response
- (void)getVerificationCodeClick:(UIButton *)sender
{
    [self.view endEditing:YES];
    NSLog(@"123");
    if (![Tools isMobileNumber:_tf_Phone.text]) {
        [SVProgressHUD showErrorWithStatus:@"请输入正确的手机号"];
        return;
    }
    [SVProgressHUD show];
    [logNetModel getLogMessage1:@"" andTelephone:self.tf_Phone.text andTag:1003 completionHandle:^(lodModel *model, NSError *error) {
        [SVProgressHUD dismiss];
        if ([model.code isEqualToString:@"0"]) {
            __block NSInteger second = TIMECOUNT;
            //(1)
            dispatch_queue_t quene = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
            //(2)
            dispatch_source_t timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, quene);
            //(3)
            dispatch_source_set_timer(timer, DISPATCH_TIME_NOW, 1 * NSEC_PER_SEC, 0 * NSEC_PER_SEC);
            //(4)
            dispatch_source_set_event_handler(timer, ^{
                dispatch_async(dispatch_get_main_queue(), ^{
                    if (second == 0) {
                        sender.userInteractionEnabled = YES;
                        [sender setTitle:[NSString stringWithFormat:@"获取验证码"] forState:UIControlStateNormal];
                        [sender setTitleColor:RGBCOLOR(23, 123, 206) forState:UIControlStateNormal];
                        second = TIMECOUNT;
                        //(6)
                        dispatch_cancel(timer);
                    } else {
                        sender.userInteractionEnabled = NO;
                        [sender setTitle:[NSString stringWithFormat:@"%ld秒后重新获取",(long)second] forState:UIControlStateNormal];
                          [sender setTitleColor:RGBCOLOR(197, 197, 197) forState:UIControlStateNormal];
                        second--;
                    }
                });
            });
            //(5)
            dispatch_resume(timer);
        }else{
            codeSelected *code = [codeSelected MustTakeReturn:[model.code intValue]];
            [code returnCodeMethod];
        }
    }];
}
- (void)loginClick:(UIButton *)btn
{
    if (![Tools isMobileNumber:_tf_Phone.text]) {
        [SVProgressHUD showErrorWithStatus:@"请输入正确的手机号"];
        return;
    }
    
    [logNetModel convenientLogin:self.tf_Phone.text andValidateCode:self.tf_VerificationCode.text andKankanId:nil andUid:nil completionHandle:^(logModel_2 *model, NSError *error) {
        [SVProgressHUD dismiss];
        if ([model.code isEqualToString:@"0"]) {
            //判断账号是否登入时候使用
            [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"firstlog"];
            [getPeopleID getLoginType:@"smslogin"];
            [getPeopleID getPeopletitle:model.result.cus_name];
            [getPeopleID getPeoplePhoto:model.result.photo];
            [getPeopleID getPeopleID:model.result.ID];
            [getPeopleID getPeopleIphoneNmber:model.result.telphone];
            AppDelegate *delegate=(AppDelegate*)[[UIApplication sharedApplication]delegate];
            
            if ( delegate.isLogin == NO) {
                [getPeopleID getProvince:model.result.provinceName];
                
            }
            if (model.result.account_type == 0) {
                [getPeopleID getpeopleLimitedAuthority:YES];
            }else{
                 [getPeopleID getpeopleLimitedAuthority:NO];
            }
            
            [self.navigationController dismissViewControllerAnimated:YES completion:nil];
        }else{
            codeSelected *code = [codeSelected MustTakeReturn:[model.code intValue]];
            [code returnCodeMethod];
            
        }
    }];
}

#pragma mark - getters and setters
- (UILabel *)lb_Title
{
    if (!_lb_Title) {
        _lb_Title = [[UILabel alloc]init];
        _lb_Title.text = @"短信快捷登录(免注册)";
        _lb_Title.textColor = RGBCOLOR(77, 77, 77);
        _lb_Title.textAlignment = NSTextAlignmentLeft;
        _lb_Title.font = [UIFont systemFontOfSize:25*WIDTHRADIU];
    }
    return _lb_Title;
}

- (UILabel*)lb_SubTitle
{
    if (!_lb_SubTitle) {
        _lb_SubTitle = [[UILabel alloc]init];
        _lb_SubTitle.text = @"未注册的手机号将自动创建账号";
        _lb_SubTitle.textColor = RGBCOLOR(153, 153, 153);
        _lb_SubTitle.textAlignment = NSTextAlignmentLeft;
        _lb_SubTitle.font = [UIFont systemFontOfSize:14*WIDTHRADIU];
    }
    return _lb_SubTitle;
}

- (UITextField *)tf_Phone
{
    if (!_tf_Phone) {
        _tf_Phone = [[UITextField alloc]init];
        _tf_Phone.keyboardType = UIKeyboardTypeNumberPad;
        _tf_Phone.placeholder = @"请输入手机号码";
        _tf_Phone.borderStyle = UITextBorderStyleNone;
        [_tf_Phone setValue:RGBCOLOR(153, 153, 153) forKeyPath:@"_placeholderLabel.textColor"];
        [_tf_Phone setValue:[UIFont systemFontOfSize:14.0 * WIDTHRADIU] forKeyPath:@"_placeholderLabel.font"];
        _tf_Phone.delegate = self;
        
    }
    return _tf_Phone;
}

- (UIView *)phoneLine
{
    if (!_phoneLine) {
        _phoneLine = [[UIView alloc]init];
        _phoneLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _phoneLine;
}

- (UITextField *)tf_VerificationCode
{
    if (!_tf_VerificationCode) {
        _tf_VerificationCode = [[UITextField alloc]init];
        _tf_VerificationCode.keyboardType = UIKeyboardTypeNumberPad;
        _tf_VerificationCode.placeholder = @"请输入验证码";
        _tf_VerificationCode.borderStyle = UITextBorderStyleNone;
        [_tf_VerificationCode setValue:RGBCOLOR(153, 153, 153) forKeyPath:@"_placeholderLabel.textColor"];
        [_tf_VerificationCode setValue:[UIFont systemFontOfSize:14.0 * WIDTHRADIU] forKeyPath:@"_placeholderLabel.font"];
        _tf_VerificationCode.delegate = self;
        
    }
    return _tf_VerificationCode;
}

- (UIView *)dividerLine
{
    if (!_dividerLine) {
        _dividerLine = [[UIView alloc]init];
        _dividerLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _dividerLine;
}

- (UIButton*)btn_VerificationCode
{
    if (!_btn_VerificationCode) {
        _btn_VerificationCode = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_VerificationCode setTitle:@"获取验证码" forState:UIControlStateNormal];
        [_btn_VerificationCode setTitleColor:RGBCOLOR(23, 123, 206) forState:UIControlStateNormal];
        _btn_VerificationCode.titleLabel.font = [UIFont systemFontOfSize:15*WIDTHRADIU];
        [_btn_VerificationCode addTarget:self action:@selector(getVerificationCodeClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_VerificationCode;
}

- (UIView *)codeLine
{
    if (!_codeLine) {
        _codeLine = [[UIView alloc]init];
        _codeLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _codeLine;
}

- (UIButton *)loginBtn
{
    if (!_loginBtn) {
        _loginBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_loginBtn setTitle:@"登录" forState:UIControlStateNormal];
        [_loginBtn.titleLabel setFont:[UIFont systemFontOfSize:16*WIDTHRADIU]];
        [_loginBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_loginBtn setBackgroundColor:RGBCOLOR(142, 142, 142)];
        _loginBtn.layer.cornerRadius = 5*WIDTHRADIU;
        
        [_loginBtn addTarget:self action:@selector(loginClick:) forControlEvents:UIControlEventTouchUpInside];
        _loginBtn.userInteractionEnabled = NO;
    }
    return _loginBtn;
}




- (LoginView *)wxLogin
{
    if (!_wxLogin) {
        _wxLogin = [[LoginView alloc]initWithTitle:@"微信登录" imageName:@"login_otherlogin_WeChat_normal-1"];
        _wxLogin.delegate = self;
    }
    return _wxLogin;
}
- (LoginView *)directlyLogin
{
    if (!_directlyLogin) {
        _directlyLogin = [[LoginView alloc]initWithTitle:@"一键登录" imageName:@"login_otherlogin_One-click_normal"];
        _directlyLogin.delegate = self;
    }
    return _directlyLogin;
}


- (LoginView *)passwordLogin
{
    if (!_passwordLogin) {
        _passwordLogin = [[LoginView alloc]initWithTitle:@"密码登录" imageName:@"login_otherlogin_password_normal"];
        _passwordLogin.delegate = self;
    }
    return _passwordLogin;
}

- (UIView *)leftLine
{
    if (!_leftLine) {
        _leftLine = [[UIView alloc]init];
        _leftLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _leftLine;
}

- (UILabel *)middleLab
{
    if (!_middleLab) {
        _middleLab = [[UILabel alloc]init];
        _middleLab.textColor = RGBACOLOR(153, 153, 153, 1.0);
        _middleLab.text = @"其他登录方式";
        _middleLab.textAlignment = NSTextAlignmentCenter;
        _middleLab.font = [UIFont systemFontOfSize:12*WIDTHRADIU];
    }
    return _middleLab;
}

- (UIView *)rightLine
{
    if (!_rightLine) {
        _rightLine = [[UIView alloc]init];
        _rightLine.backgroundColor = RGBCOLOR(204, 204, 204);
    }
    return _rightLine;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
