//
//  PopView.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/7/2.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "PopView.h"
#import "UIColor+Hex.h"
#import "Constants.h"

#import <Masonry.h>

@interface PopView ()


@end

@implementation PopView
#pragma mark - life cycle
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self addSubview:self.imageView];
        [self addSubview:self.textLabel];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self);
    }];
    
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.equalTo(self);
    }];
}

#pragma mark - getters and setters
- (UIImageView *)imageView
{
    if (!_imageView) {
        _imageView = [[UIImageView alloc]init];
        
        UIImage *oldImage = [UIImage imageNamed:@"my_information_moneybg_normal"];
        UIImage *newImage = [oldImage stretchableImageWithLeftCapWidth:8 topCapHeight:0];
        _imageView.image = newImage;
    }
    return _imageView;
}

- (UILabel *)textLabel
{
    if (!_textLabel) {
        _textLabel = [[UILabel alloc]init];
        _textLabel.textColor = [UIColor whiteColor];
        _textLabel.font = [UIFont systemFontOfSize:8 * WIDTHRADIU];
        _textLabel.text = @"约1.02元";
    }
    return _textLabel;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
