//
//  LogHeaderView.m
//  GtDemo
//
//  Created by 雷俊博 on 2019/7/1.
//  Copyright © 2019 雷俊博. All rights reserved.
//

#import "LogHeaderView.h"
#import "LogTopView.h"
#import "Constants.h"
#import "UIColor+Hex.h"

#import <Masonry.h>



@interface LogHeaderView ()<LogTapClickDelegate>

@property (nonatomic, strong)UIImageView *backView;
@property (nonatomic, strong)LogTopView *cardView;

@end

@implementation LogHeaderView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self addSubview:self.backView];
        [self addSubview:self.cardView];
       
        [self setUpUI];
    }
    return self;
}

- (void)setUpUI
{
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(0 * WIDTHRADIU);
        make.left.offset(0 * WIDTHRADIU);
        make.right.offset(0 * WIDTHRADIU);
        make.height.offset(145 * WIDTHRADIU);
    }];
    
    [self.cardView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(20 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.right.offset(-20 * WIDTHRADIU);
        make.bottom.offset(-20 * WIDTHRADIU);
    }];
}

#pragma mark - LogTapClickDelegate
- (void)tapPhotoClickWithType:(NSString *)type
{
    NSLog(@"123");
   
        if ([self.delegate respondsToSelector:@selector(clickWithType:)]) {
            
            [self.delegate clickWithType:type];
           
        }
    
    
}

#pragma mark - public method
- (void)refreshData
{
    [self.cardView refreshData];
}

#pragma mark - getters and setters
- (UIImageView *)backView
{
    if (!_backView) {
        _backView = [[UIImageView alloc]init];
        _backView.image = [UIImage imageNamed:@"my-bg"];
    }
    return _backView;
}

- (LogTopView *)cardView
{
    if (!_cardView) {
        _cardView = [[LogTopView alloc]init];
        _cardView.backgroundColor = [UIColor whiteColor];
        _cardView.layer.shadowColor = RGBCOLOR(23, 123, 205).CGColor;
        _cardView.layer.shadowOffset = CGSizeMake(0, 0);
        _cardView.layer.shadowOpacity = 0.25;
        _cardView.layer.shadowRadius = 2.0;
        _cardView.layer.cornerRadius = 10 * WIDTHRADIU;
        _cardView.delegate = self;
    }
    return _cardView;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
